/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.composite;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.resource.IRepositoryBase;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.RepositoryResourceBaseSelectionComposite;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.common.RepositoryTreePanel;
import org.eclipse.team.svn.ui.verifier.AbsolutePathVerifier;
import org.eclipse.team.svn.ui.verifier.CompositeVerifier;
import org.eclipse.team.svn.ui.verifier.IValidationManager;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.eclipse.team.svn.ui.verifier.URLVerifier;

public class RepositoryResourceOnlySelectionComposite
extends RepositoryResourceBaseSelectionComposite {
    protected boolean isMatchToBaseResource;

    public RepositoryResourceOnlySelectionComposite(Composite parent, int style, IValidationManager validationManager, String historyKey, IRepositoryResource baseResource, String selectionTitle, String selectionDescription) {
        this(parent, style, validationManager, historyKey, "RepositoryResourceOnlySelectionComposite_URL", baseResource, selectionTitle, selectionDescription);
    }

    public RepositoryResourceOnlySelectionComposite(Composite parent, int style, IValidationManager validationManager, String historyKey, String comboId, IRepositoryResource baseResource, String selectionTitle, String selectionDescription) {
        super(parent, style, validationManager, historyKey, comboId, baseResource, selectionTitle, selectionDescription);
        this.createControls();
    }

    public void setMatchToBaseResource(boolean isMatchToBaseResource) {
        this.isMatchToBaseResource = isMatchToBaseResource;
    }

    public boolean isMatchToBaseResource() {
        return this.isMatchToBaseResource;
    }

    private void createControls() {
        GridLayout layout = null;
        GridData data = null;
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        Label urlLabel = new Label((Composite)this, 0);
        urlLabel.setLayoutData((Object)new GridData());
        urlLabel.setText(SVNUIMessages.getString(this.comboId));
        Composite select = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        select.setLayout((Layout)layout);
        data = new GridData(768);
        select.setLayoutData((Object)data);
        this.urlText = new Combo(select, 0);
        data = new GridData(768);
        data.widthHint = 200;
        this.urlText.setLayoutData((Object)data);
        this.urlText.setVisibleItemCount(this.urlHistory.getDepth());
        this.urlText.setItems(this.urlHistory.getHistory());
        if (this.baseResource != null) {
            this.urlText.setText(this.baseResource.getUrl());
        }
        this.url = this.urlText.getText();
        Listener urlTextListener = e -> {
            String string = this.url = ((Combo)e.widget).getText();
        };
        this.urlText.addListener(13, urlTextListener);
        this.urlText.addListener(24, urlTextListener);
        this.verifier = new CompositeVerifier();
        this.verifier.add(new NonEmptyFieldVerifier(SVNUIMessages.getString(this.comboId + "_Verifier")));
        this.verifier.add(new URLVerifier(SVNUIMessages.getString(this.comboId + "_Verifier")){

            @Override
            protected String getErrorMessage(Control input) {
                String error = super.getErrorMessage(input);
                if (RepositoryResourceOnlySelectionComposite.this.baseResource != null && error == null) {
                    String baseResourceUrl;
                    String url = this.getText(input);
                    if (RepositoryResourceOnlySelectionComposite.this.getDestination(SVNUtility.asEntryReference((String)url), true) == null) {
                        error = BaseMessages.format((String)SVNUIMessages.RepositoryResourceOnlySelectionComposite_URL_Verifier_Error, (Object[])new String[]{url, RepositoryResourceOnlySelectionComposite.this.baseResource.getRepositoryLocation().getUrl()});
                    }
                    if (error == null && RepositoryResourceOnlySelectionComposite.this.isMatchToBaseResource && !url.startsWith(baseResourceUrl = RepositoryResourceOnlySelectionComposite.this.baseResource.getUrl())) {
                        error = BaseMessages.format((String)SVNUIMessages.RepositoryResourceOnlySelectionComposite_URL_Verifier_Error, (Object[])new String[]{url, baseResourceUrl});
                    }
                }
                return error;
            }
        });
        this.verifier.add(new AbsolutePathVerifier(this.comboId));
        this.validationManager.attachTo((Control)this.urlText, this.verifier);
        this.browse = new Button(select, 8);
        this.browse.setText(SVNUIMessages.Button_Browse);
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(this.browse);
        this.browse.setLayoutData((Object)data);
        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryTreePanel panel = new RepositoryTreePanel(SVNUIMessages.RepositoryResourceOnlySelectionComposite_Select_Title, RepositoryResourceOnlySelectionComposite.this.selectionTitle, RepositoryResourceOnlySelectionComposite.this.selectionDescription, null, true, (IRepositoryBase)RepositoryResourceOnlySelectionComposite.this.baseResource, false);
                panel.setAllowFiles(!RepositoryResourceOnlySelectionComposite.this.foldersOnly);
                DefaultDialog browser = new DefaultDialog(RepositoryResourceOnlySelectionComposite.this.getShell(), panel);
                if (browser.open() == 0) {
                    IRepositoryResource selectedResource = panel.getSelectedResource();
                    boolean samePeg = RepositoryResourceOnlySelectionComposite.this.baseResource != null && selectedResource.getPegRevision().equals((Object)RepositoryResourceOnlySelectionComposite.this.baseResource.getPegRevision());
                    RepositoryResourceOnlySelectionComposite.this.urlText.setText(samePeg ? selectedResource.getUrl() : SVNUtility.getEntryReference((IRepositoryResource)selectedResource).toString());
                    RepositoryResourceOnlySelectionComposite.this.validationManager.validateContent();
                }
            }
        });
    }
}

