/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.utility;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.Team;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.PathForURL;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.SVNTeamProvider;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.ISVNPropertyCallback;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNDiffStatus;
import org.eclipse.team.svn.core.connector.SVNEntry;
import org.eclipse.team.svn.core.connector.SVNEntryInfo;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNEntryStatus;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;
import org.eclipse.team.svn.core.connector.ssl.SSLServerCertificateInfo;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.extension.options.IIgnoreRecommendations;
import org.eclipse.team.svn.core.operation.SVNNullProgressMonitor;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.operation.file.SVNFileStorage;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryRoot;
import org.eclipse.team.svn.core.resource.IRevisionLink;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.svnstorage.SVNRevisionLink;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.PatternProvider;
import org.eclipse.team.svn.core.utility.RepositoryLocationUtility;
import org.eclipse.team.svn.core.utility.SVNLogEntryCallbackWithMergeInfo;
import org.eclipse.team.svn.core.utility.SVNNotificationComposite;
import org.eclipse.team.svn.core.utility.SVNURLStreamHandler;

public final class SVNUtility {
    private static String svnFolderName = null;
    private static final byte[] uri_char_validity;
    private static final Pattern MERGE_PART;

    static {
        byte[] byArray = new byte[256];
        byArray[33] = 1;
        byArray[36] = 1;
        byArray[38] = 1;
        byArray[39] = 1;
        byArray[40] = 1;
        byArray[41] = 1;
        byArray[42] = 1;
        byArray[43] = 1;
        byArray[44] = 1;
        byArray[45] = 1;
        byArray[46] = 1;
        byArray[47] = 1;
        byArray[48] = 1;
        byArray[49] = 1;
        byArray[50] = 1;
        byArray[51] = 1;
        byArray[52] = 1;
        byArray[53] = 1;
        byArray[54] = 1;
        byArray[55] = 1;
        byArray[56] = 1;
        byArray[57] = 1;
        byArray[58] = 1;
        byArray[61] = 1;
        byArray[64] = 1;
        byArray[65] = 1;
        byArray[66] = 1;
        byArray[67] = 1;
        byArray[68] = 1;
        byArray[69] = 1;
        byArray[70] = 1;
        byArray[71] = 1;
        byArray[72] = 1;
        byArray[73] = 1;
        byArray[74] = 1;
        byArray[75] = 1;
        byArray[76] = 1;
        byArray[77] = 1;
        byArray[78] = 1;
        byArray[79] = 1;
        byArray[80] = 1;
        byArray[81] = 1;
        byArray[82] = 1;
        byArray[83] = 1;
        byArray[84] = 1;
        byArray[85] = 1;
        byArray[86] = 1;
        byArray[87] = 1;
        byArray[88] = 1;
        byArray[89] = 1;
        byArray[90] = 1;
        byArray[95] = 1;
        byArray[97] = 1;
        byArray[98] = 1;
        byArray[99] = 1;
        byArray[100] = 1;
        byArray[101] = 1;
        byArray[102] = 1;
        byArray[103] = 1;
        byArray[104] = 1;
        byArray[105] = 1;
        byArray[106] = 1;
        byArray[107] = 1;
        byArray[108] = 1;
        byArray[109] = 1;
        byArray[110] = 1;
        byArray[111] = 1;
        byArray[112] = 1;
        byArray[113] = 1;
        byArray[114] = 1;
        byArray[115] = 1;
        byArray[116] = 1;
        byArray[117] = 1;
        byArray[118] = 1;
        byArray[119] = 1;
        byArray[120] = 1;
        byArray[121] = 1;
        byArray[122] = 1;
        byArray[126] = 1;
        uri_char_validity = byArray;
        MERGE_PART = Pattern.compile("r\\d+");
    }

    public static String formatSSLFingerprint(byte[] fingerprint) {
        Object retVal = "";
        byte[] byArray = fingerprint;
        int n = fingerprint.length;
        int n2 = 0;
        while (n2 < n) {
            byte data = byArray[n2];
            String part = String.format("%02x", data);
            retVal = (String)retVal + (String)(((String)retVal).length() > 0 ? ":" + part : part);
            ++n2;
        }
        return retVal;
    }

    public static String formatSSLValid(Date validFrom, Date validTo) {
        SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.ENGLISH);
        return "from " + df.format(validFrom) + " until " + df.format(validTo);
    }

    public static SSLServerCertificateInfo decodeCertificateData(Map<String, String> map) throws ParseException {
        String serverURL = map.get("serverURL") != null ? map.get("serverURL") : "";
        String issuer = map.get("issuer");
        String subject = map.get("subject");
        String[] parts = map.get("fingerprint") == null ? new String[]{} : map.get("fingerprint").split(":");
        byte[] fingerprint = new byte[parts.length];
        int k = 0;
        while (k < parts.length) {
            try {
                fingerprint[k] = (byte)Integer.parseInt(parts[k], 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(parts[k], 0);
            }
            ++k;
        }
        String valid = map.get("valid");
        long validFrom = 0L;
        long validTo = 0L;
        if (valid != null) {
            SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.ENGLISH);
            String fromStr = valid.substring(5, valid.indexOf("until") - 1);
            String toStr = valid.substring(valid.indexOf("until") + 6);
            validFrom = df.parse(fromStr).getTime();
            validTo = df.parse(toStr).getTime();
        }
        return new SSLServerCertificateInfo(subject, issuer, validFrom, validTo, fingerprint, Arrays.asList(serverURL), null);
    }

    public static Map<String, String> splitCertificateString(String message) {
        HashMap<String, String> retVal = new HashMap<String, String>();
        String[] baseLines = message.split("\n");
        boolean infoMessagePart = false;
        String infoMessage = null;
        String[] stringArray = baseLines;
        int n = baseLines.length;
        int n2 = 0;
        while (n2 < n) {
            String baseLine = stringArray[n2];
            int idx1 = baseLine.indexOf("https:");
            if (idx1 != -1) {
                String serverURL = baseLine.substring(idx1).trim();
                serverURL = serverURL.substring(0, serverURL.length() - 2);
                retVal.put("serverURL", serverURL);
                infoMessagePart = true;
            } else if (infoMessagePart) {
                if (baseLine.endsWith(":")) {
                    infoMessagePart = false;
                } else {
                    infoMessage = infoMessage == null ? baseLine : infoMessage + "\n" + baseLine;
                }
            } else {
                int idx = baseLine.indexOf(58);
                String key = baseLine.substring(0, idx).replaceFirst("\\s*-\\s*", "").trim();
                String value = baseLine.substring(idx + 1).trim();
                if ("Subject".equals(key)) {
                    retVal.put("subject", value);
                } else if ("Valid".equals(key)) {
                    retVal.put("valid", value);
                } else if ("Issuer".equals(key)) {
                    retVal.put("issuer", value);
                } else if ("Fingerprint".equals(key)) {
                    retVal.put("fingerprint", value);
                }
            }
            ++n2;
        }
        retVal.put("infoMessage", infoMessage);
        return retVal;
    }

    public static boolean isPriorToSVN17() {
        return CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() < 7;
    }

    public static IRepositoryResource asRepositoryResource(String url, boolean isFolder) {
        if (!SVNUtility.isValidSVNURL(url)) {
            return null;
        }
        IRepositoryRoot[] roots = SVNUtility.findRoots(url, true);
        IRepositoryResource retVal = null;
        if (roots.length > 0) {
            retVal = isFolder ? roots[0].asRepositoryContainer(url, false) : roots[0].asRepositoryFile(url, false);
        } else {
            IRepositoryLocation location = SVNRemoteStorage.instance().newRepositoryLocation();
            SVNUtility.initializeRepositoryLocation(location, url);
            retVal = isFolder ? location.asRepositoryContainer(url, false) : location.asRepositoryFile(url, false);
        }
        return retVal;
    }

    public static void initializeRepositoryLocation(IRepositoryLocation location, String url) {
        location.setStructureEnabled(true);
        location.setTrunkLocation(CoreExtensionsManager.instance().getOptionProvider().getString("defaultTrunkName"));
        location.setBranchesLocation(CoreExtensionsManager.instance().getOptionProvider().getString("defaultBranchesName"));
        location.setTagsLocation(CoreExtensionsManager.instance().getOptionProvider().getString("defaultTagsName"));
        IPath urlPath = SVNUtility.createPathForSVNUrl(url);
        if (urlPath.lastSegment().equals(location.getTrunkLocation())) {
            url = urlPath.removeLastSegments(1).toString();
        }
        location.setUrl(url);
    }

    public static IRepositoryResource getCopiedFrom(IResource resource) {
        return SVNUtility.getCopiedFrom(SVNRemoteStorage.instance().asLocalResource(resource));
    }

    public static IRepositoryResource getCopiedFrom(ILocalResource local) {
        if (local.isCopied()) {
            IResource resource = local.getResource();
            IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(resource);
            ISVNConnector proxy = location.acquireSVNProxy();
            String path = FileUtility.getWorkingCopyPath(resource);
            SVNEntryInfo[] st = null;
            try {
                try {
                    st = SVNUtility.info(proxy, new SVNEntryRevisionReference(path), SVNDepth.EMPTY, new SVNNullProgressMonitor());
                }
                catch (SVNConnectorException sVNConnectorException) {
                    location.releaseSVNProxy(proxy);
                    return null;
                }
            }
            finally {
                location.releaseSVNProxy(proxy);
            }
            if (st[0] != null) {
                Object url = st[0].copyFromUrl;
                if (url == null) {
                    IRepositoryResource tmp;
                    IContainer parent = resource.getParent();
                    if (parent != null && parent.getType() != 8 && (tmp = SVNUtility.getCopiedFrom((IResource)parent)) != null) {
                        url = tmp.getUrl() + "/" + resource.getName();
                    }
                } else {
                    url = SVNUtility.decodeURL((String)url);
                }
                IRepositoryResource retVal = SVNRemoteStorage.instance().asRepositoryResource(location, (String)url, resource.getType() == 1);
                retVal.setSelectedRevision(SVNRevision.fromNumber(st[0].copyFromRevision == -1L ? st[0].revision : st[0].copyFromRevision));
                return retVal;
            }
        }
        return null;
    }

    public static Map<String, SVNEntryRevisionReference> parseSVNExternalsProperty(String property, IRepositoryResource propertyHolder) {
        SVNExternalPropertyData[] externalsData;
        HashMap<String, SVNEntryRevisionReference> retVal = new HashMap<String, SVNEntryRevisionReference>();
        SVNExternalPropertyData[] sVNExternalPropertyDataArray = externalsData = SVNExternalPropertyData.parse(property);
        int n = externalsData.length;
        int n2 = 0;
        while (n2 < n) {
            SVNExternalPropertyData externalData = sVNExternalPropertyDataArray[n2];
            String url = externalData.url.trim();
            SVNRevision revision = null;
            SVNRevision pegRevision = null;
            try {
                if (externalData.revision != null) {
                    revision = SVNRevision.fromString(externalData.revision);
                }
                if (externalData.pegRevision != null) {
                    revision = SVNRevision.fromString(externalData.pegRevision);
                }
            }
            catch (Exception exception) {
                throw new UnreportableException("Malformed external, " + externalData.toString());
            }
            url = SVNUtility.replaceRelativeExternalParts(url, propertyHolder);
            try {
                url = SVNUtility.decodeURL(url);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                url = SVNUtility.normalizeURL(url);
            }
            retVal.put(externalData.localPath, new SVNEntryRevisionReference(url, pegRevision, revision));
            ++n2;
        }
        return retVal;
    }

    public static String replaceRelativeExternalParts(String url, IRepositoryResource resource) throws UnreportableException {
        block13: {
            if (SVNUtility.isValidSVNURL((String)url)) {
                return url;
            }
            if (((String)url).startsWith("^/")) {
                url = resource.getRepositoryLocation().getRepositoryRoot().getUrl() + ((String)url).substring(1);
            } else if (((String)url).startsWith("//")) {
                try {
                    String protocol = SVNUtility.getSVNUrl(resource.getUrl()).getProtocol();
                    if (resource.getUrl().indexOf(":///") != -1) {
                        url = protocol + ":/" + (String)url;
                        break block13;
                    }
                    url = protocol + ":" + (String)url;
                }
                catch (MalformedURLException malformedURLException) {}
            } else if (((String)url).startsWith("/")) {
                String prefix = resource.getUrl();
                int idx = prefix.lastIndexOf("//");
                idx = prefix.indexOf(47, idx + 2);
                url = prefix.substring(0, idx) + (String)url;
            } else if (((String)url).startsWith("../")) {
                IRepositoryResource prefix = resource;
                while (((String)url).startsWith("../")) {
                    url = ((String)url).substring(3);
                    if ((prefix = prefix.getParent()) != null) continue;
                    throw new UnreportableException("Malformed url: " + (String)url);
                }
                url = prefix.getUrl() + "/" + (String)url;
            } else {
                throw new UnreportableException("Malformed url: " + (String)url);
            }
        }
        return url;
    }

    public static SVNEntryReference asEntryReference(String url) {
        if (url == null) {
            return null;
        }
        int idx = url.lastIndexOf(64);
        SVNRevision peg = null;
        if (idx != -1) {
            try {
                peg = SVNRevision.fromString(url.substring(idx + 1));
                url = url.substring(0, idx);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return new SVNEntryReference(url, peg);
    }

    public static boolean useSingleReferenceSignature(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2) {
        SVNRevision.Kind kind1 = reference1.revision.getKind();
        SVNRevision.Kind kind2 = reference2.revision.getKind();
        if (!(kind1 != SVNRevision.Kind.BASE && kind1 != SVNRevision.Kind.WORKING || kind2 != SVNRevision.Kind.BASE && kind2 != SVNRevision.Kind.WORKING)) {
            return false;
        }
        return reference1.path.equals(reference2.path) && (reference1.pegRevision == reference2.pegRevision || reference1.pegRevision != null && reference1.pegRevision.equals(reference2.pegRevision));
    }

    public static SVNEntryRevisionReference getEntryRevisionReference(IRepositoryResource resource) {
        return new SVNEntryRevisionReference(SVNUtility.encodeURL(resource.getUrl()), resource.getPegRevision(), resource.getSelectedRevision());
    }

    public static SVNEntryReference getEntryReference(IRepositoryResource resource) {
        return new SVNEntryReference(SVNUtility.encodeURL(resource.getUrl()), resource.getPegRevision());
    }

    public static SVNProperty[] properties(ISVNConnector proxy, SVNEntryRevisionReference reference, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        SVNProperty[][] retVal = new SVNProperty[1][];
        proxy.listProperties(reference, SVNDepth.EMPTY, null, options, (personalProps, inheritedProps) -> {
            ArrayList props = new ArrayList();
            Collections.addAll(props, personalProps.data);
            ISVNPropertyCallback.Pair[] pairArray = inheritedProps;
            int n = inheritedProps.length;
            int n2 = 0;
            while (n2 < n) {
                ISVNPropertyCallback.Pair iProps = pairArray[n2];
                Collections.addAll(props, iProps.data);
                ++n2;
            }
            sVNPropertyArray[0] = personalProps.data;
        }, monitor);
        return retVal[0];
    }

    public static SVNChangeStatus[] status(ISVNConnector proxy, String path, SVNDepth depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ArrayList statuses = new ArrayList();
        proxy.status(path, depth, options, null, status -> {
            boolean bl = statuses.add(status);
        }, monitor);
        Iterator it = statuses.iterator();
        while (it.hasNext() && !monitor.isActivityCancelled()) {
            SVNChangeStatus svnChangeStatus = (SVNChangeStatus)it.next();
            if (!svnChangeStatus.hasConflict || svnChangeStatus.treeConflicts != null) continue;
            proxy.getInfo(new SVNEntryRevisionReference(svnChangeStatus.path), SVNDepth.EMPTY, 0x1000000000L, null, info -> svnChangeStatus.setTreeConflicts(info.treeConflicts), monitor);
        }
        return statuses.toArray(new SVNChangeStatus[statuses.size()]);
    }

    public static void diffStatus(ISVNConnector proxy, Collection<SVNDiffStatus> statuses, SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, SVNDepth depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        proxy.diffStatusTwo(reference1, reference2, depth, options, null, status -> {
            boolean bl = statuses.add(status);
        }, monitor);
    }

    public static void diffStatus(ISVNConnector proxy, Collection<SVNDiffStatus> statuses, SVNEntryReference reference, SVNRevisionRange range, SVNDepth depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        proxy.diffStatus(reference, range, depth, options, null, status -> {
            boolean bl = statuses.add(status);
        }, monitor);
    }

    public static SVNEntry[] list(ISVNConnector proxy, SVNEntryRevisionReference reference, SVNDepth depth, int direntFields, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ArrayList entries = new ArrayList();
        proxy.listEntries(reference, depth, direntFields, options, entry -> {
            boolean bl = entries.add(entry);
        }, monitor);
        return entries.toArray(new SVNEntry[entries.size()]);
    }

    public static SVNLogEntry[] logEntries(ISVNConnector proxy, SVNEntryReference reference, SVNRevision revisionStart, SVNRevision revisionEnd, long options, String[] revProps, long limit, ISVNProgressMonitor monitor) throws SVNConnectorException {
        return SVNUtility.logEntries(proxy, reference, new SVNRevisionRange[]{new SVNRevisionRange(revisionStart, revisionEnd)}, options, revProps, limit, monitor);
    }

    public static SVNLogEntry[] logEntries(ISVNConnector proxy, SVNEntryReference reference, SVNRevisionRange[] revisionRanges, long options, String[] revProps, long limit, ISVNProgressMonitor monitor) throws SVNConnectorException {
        SVNLogEntryCallbackWithMergeInfo callback = new SVNLogEntryCallbackWithMergeInfo();
        proxy.listHistoryLog(reference, revisionRanges, revProps, limit, options, callback, monitor);
        return callback.getEntries();
    }

    public static SVNEntryInfo[] info(SVNEntryRevisionReference reference) {
        ISVNConnector proxy = CoreExtensionsManager.instance().getSVNConnectorFactory().createConnector();
        try {
            SVNEntryInfo[] sVNEntryInfoArray = SVNUtility.info(proxy, reference, SVNDepth.EMPTY, new SVNNullProgressMonitor());
            return sVNEntryInfoArray;
        }
        catch (Exception exception) {
            return null;
        }
        finally {
            proxy.dispose();
        }
    }

    public static SVNEntryInfo[] info(ISVNConnector proxy, SVNEntryRevisionReference reference, SVNDepth depth, ISVNProgressMonitor monitor) throws SVNConnectorException {
        ArrayList infos = new ArrayList();
        proxy.getInfo(reference, depth, 0x1000000000L, null, info -> {
            boolean bl = infos.add(info);
        }, monitor);
        return infos.toArray(new SVNEntryInfo[infos.size()]);
    }

    public static SVNEntryRevisionReference convertRevisionReference(ISVNConnector proxy, SVNEntryRevisionReference entry, ISVNProgressMonitor monitor) throws SVNConnectorException {
        SVNEntryInfo[] info;
        if (entry.revision != null && entry.pegRevision != null && !entry.revision.equals(entry.pegRevision) && entry.revision.getKind() == SVNRevision.Kind.NUMBER && (info = SVNUtility.info(proxy, entry, SVNDepth.EMPTY, monitor)) != null && info.length > 0 && info[0].url != null) {
            return new SVNEntryRevisionReference(info[0].url, entry.revision, entry.revision);
        }
        return entry;
    }

    public static String getStatusText(String status) {
        if (status == null) {
            status = "NotExists";
        }
        return SVNMessages.getString("Status_" + status);
    }

    public static IRepositoryRoot getTrunkLocation(IRepositoryResource resource) {
        return SVNUtility.getRootLocation(resource, resource.getRepositoryLocation().getTrunkLocation(), 1);
    }

    public static IRepositoryRoot getBranchesLocation(IRepositoryResource resource) {
        return SVNUtility.getRootLocation(resource, resource.getRepositoryLocation().getBranchesLocation(), 2);
    }

    public static IRepositoryRoot getTagsLocation(IRepositoryResource resource) {
        return SVNUtility.getRootLocation(resource, resource.getRepositoryLocation().getTagsLocation(), 3);
    }

    public static IRepositoryContainer getProposedTrunk(IRepositoryLocation location) {
        return location.asRepositoryContainer(SVNUtility.getProposedTrunkLocation(location), false);
    }

    public static IRepositoryContainer getProposedBranches(IRepositoryLocation location) {
        return location.asRepositoryContainer(SVNUtility.getProposedBranchesLocation(location), false);
    }

    public static IRepositoryContainer getProposedTags(IRepositoryLocation location) {
        return location.asRepositoryContainer(SVNUtility.getProposedTagsLocation(location), false);
    }

    public static String getProposedTrunkLocation(IRepositoryLocation location) {
        String baseUrl = location.getUrl();
        return location.isStructureEnabled() ? baseUrl + "/" + location.getTrunkLocation() : baseUrl;
    }

    public static String getProposedBranchesLocation(IRepositoryLocation location) {
        String baseUrl = location.getUrl();
        return location.isStructureEnabled() ? baseUrl + "/" + location.getBranchesLocation() : baseUrl;
    }

    public static String getProposedTagsLocation(IRepositoryLocation location) {
        String baseUrl = location.getUrl();
        return location.isStructureEnabled() ? baseUrl + "/" + location.getTagsLocation() : baseUrl;
    }

    public static IRepositoryRoot[] findRoots(String resourceUrl, boolean longestOnly) {
        if (!SVNUtility.isValidSVNURL(resourceUrl)) {
            return new IRepositoryRoot[0];
        }
        IPath url = SVNUtility.createPathForSVNUrl(resourceUrl);
        IRepositoryLocation[] locations = SVNRemoteStorage.instance().getRepositoryLocations();
        ArrayList<IRepositoryRoot> roots = new ArrayList<IRepositoryRoot>();
        IRepositoryLocation[] iRepositoryLocationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryLocation location = iRepositoryLocationArray[n2];
            IPath locationUrl = SVNUtility.createPathForSVNUrl(location.getUrl());
            if ((url.segmentCount() >= locationUrl.segmentCount() || url.isPrefixOf(locationUrl)) && (locationUrl.isPrefixOf(url) || SVNUtility.createPathForSVNUrl(location.getRepositoryRootUrl()).isPrefixOf(url))) {
                SVNUtility.addRepositoryRoot(roots, (IRepositoryRoot)location.asRepositoryContainer(resourceUrl, false).getRoot(), longestOnly);
            }
            ++n2;
        }
        IRepositoryRoot[] repositoryRoots = roots.toArray(new IRepositoryRoot[roots.size()]);
        if (!longestOnly) {
            Arrays.sort(repositoryRoots, Comparator.comparing(IRepositoryResource::getUrl).reversed());
        }
        return repositoryRoots;
    }

    private static void addRepositoryRoot(List<IRepositoryRoot> container, IRepositoryRoot root, boolean longestOnly) {
        if (longestOnly && container.size() > 0) {
            int cnt2;
            int cnt = SVNUtility.createPathForSVNUrl(root.getUrl()).segmentCount();
            if (cnt > (cnt2 = SVNUtility.createPathForSVNUrl(container.get(0).getUrl()).segmentCount())) {
                container.clear();
                container.add(root);
            } else if (cnt == cnt2) {
                container.add(root);
            }
        } else {
            container.add(root);
        }
    }

    public static String getSVNFolderName() {
        if (svnFolderName == null) {
            String name = FileUtility.getEnvironmentVariables().get("SVN_ASP_DOT_NET_HACK") != null ? "_svn" : ".svn";
            svnFolderName = System.getProperty("javasvn.admindir", name);
        }
        return svnFolderName;
    }

    public static boolean hasSVNFolderInOrAbove(IResource resource) {
        IPath location = FileUtility.getResourcePath(resource);
        return location != null && SVNUtility.hasSVNFolderInOrAbove(location.toFile());
    }

    public static boolean hasSVNFolderInOrAbove(File node) {
        String svnFolderName = SVNUtility.getSVNFolderName();
        File file = node = node.isFile() ? node.getParentFile() : node;
        do {
            if (!new File(node, svnFolderName).exists()) continue;
            return true;
        } while ((node = node.getParentFile()) != null);
        return false;
    }

    public static String getResourceParent(IRepositoryResource resource) {
        String rootUrl;
        String parent = "";
        String url = resource.getUrl();
        if (url.equals(rootUrl = resource.getRoot().getUrl())) {
            return "";
        }
        parent = url.substring(rootUrl.length(), url.length() - resource.getName().length() - 1);
        return parent;
    }

    public static IRepositoryResource copyOf(IRepositoryResource resource) {
        String url = resource.getUrl();
        return resource instanceof IRepositoryFile ? resource.asRepositoryFile(url, false) : resource.asRepositoryContainer(url, false);
    }

    public static IRevisionLink createRevisionLink(IRepositoryResource resource) {
        return new SVNRevisionLink(resource);
    }

    public static IRepositoryResource[] makeResourceSet(IRepositoryResource upPoint, String relativeReference, boolean isFile) {
        String url = SVNUtility.normalizeURL(upPoint.getUrl() + "/" + relativeReference);
        IRepositoryLocation location = upPoint.getRepositoryLocation();
        IRepositoryResource downPoint = isFile ? location.asRepositoryFile(url, false) : location.asRepositoryContainer(url, false);
        downPoint.setPegRevision(upPoint.getPegRevision());
        downPoint.setSelectedRevision(upPoint.getSelectedRevision());
        return SVNUtility.makeResourceSet(upPoint, downPoint);
    }

    public static IRepositoryResource[] makeResourceSet(IRepositoryResource upPoint, IRepositoryResource downPoint) {
        ArrayList<IRepositoryResource> resourceSet = new ArrayList<IRepositoryResource>();
        while (downPoint != null && !downPoint.equals(upPoint)) {
            resourceSet.add(0, downPoint);
            downPoint = downPoint.getParent();
        }
        return resourceSet.toArray(new IRepositoryResource[resourceSet.size()]);
    }

    public static boolean isValidSVNURL(String url) {
        try {
            URL svnUrl = SVNUtility.getSVNUrl(url);
            String host = svnUrl.getHost();
            return (host.matches("[a-zA-Z0-9_\\-]+(?:\\.[a-zA-Z0-9_\\-]+)*") || host.length() <= 0) && (host.length() != 0 || "file".equals(svnUrl.getProtocol()));
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public static URL getSVNUrl(String url) throws MalformedURLException {
        return SVNUtility.getSVNUrlStreamHandler(url).getURL();
    }

    public static SVNURLStreamHandler getSVNUrlStreamHandler(String url) throws MalformedURLException {
        SVNURLStreamHandler retVal = new SVNURLStreamHandler();
        new URL(null, url, retVal);
        return retVal;
    }

    public static String base64Encode(String data) {
        if (data == null) {
            return null;
        }
        return new String(Base64.encode((byte[])data.getBytes()));
    }

    public static String base64Decode(String encoded) {
        if (encoded == null) {
            return null;
        }
        return new String(Base64.decode((byte[])encoded.getBytes()));
    }

    public static void addSVNNotifyListener(ISVNConnector proxy, ISVNNotificationCallback listener) {
        ISVNNotificationCallback composite = proxy.getNotificationCallback();
        if (composite == null || !(composite instanceof SVNNotificationComposite)) {
            composite = new SVNNotificationComposite();
            proxy.setNotificationCallback(composite);
        }
        ((SVNNotificationComposite)composite).add(listener);
    }

    public static void removeSVNNotifyListener(ISVNConnector proxy, ISVNNotificationCallback listener) {
        ISVNNotificationCallback composite = proxy.getNotificationCallback();
        if (composite != null && composite instanceof SVNNotificationComposite) {
            ((SVNNotificationComposite)composite).remove(listener);
        }
    }

    public static void reorder(SVNDiffStatus[] statuses, final boolean parent2Child) {
        SVNDiffStatus[] tStatuses = new SVNDiffStatus[statuses.length];
        System.arraycopy(statuses, 0, tStatuses, 0, statuses.length);
        Arrays.sort(tStatuses, new Comparator<SVNDiffStatus>(){

            @Override
            public int compare(SVNDiffStatus d1, SVNDiffStatus d2) {
                int retVal;
                int n = retVal = parent2Child ? d1.pathPrev.compareTo(d2.pathPrev) : d2.pathPrev.compareTo(d1.pathPrev);
                if (retVal == 0 && d1.textStatus != d2.textStatus) {
                    if (d1.textStatus == SVNEntryStatus.Kind.DELETED) {
                        return parent2Child ? -1 : 1;
                    }
                    if (d2.textStatus == SVNEntryStatus.Kind.DELETED) {
                        return parent2Child ? 1 : -1;
                    }
                }
                return retVal;
            }

            @Override
            public boolean equals(Object obj) {
                return false;
            }
        });
        int i = 0;
        int k = 0;
        while (i < tStatuses.length) {
            if (tStatuses[i] != null) {
                statuses[k] = tStatuses[i];
                ++k;
                if (tStatuses[i].textStatus == SVNEntryStatus.Kind.DELETED) {
                    int m = i + 1;
                    while (m < tStatuses.length) {
                        if (tStatuses[m] != null && tStatuses[m].textStatus == SVNEntryStatus.Kind.DELETED && tStatuses[m].pathPrev.indexOf(tStatuses[i].pathPrev) == 0) {
                            statuses[k] = tStatuses[m];
                            ++k;
                            tStatuses[m] = null;
                        }
                        ++m;
                    }
                }
            }
            ++i;
        }
    }

    public static void reorder(SVNChangeStatus[] statuses, final boolean parent2Child) {
        Arrays.sort(statuses, new Comparator<SVNChangeStatus>(){

            @Override
            public int compare(SVNChangeStatus o1, SVNChangeStatus o2) {
                String s1 = o1 != null ? o1.path : "";
                String s2 = o2 != null ? o2.path : "";
                return parent2Child ? s1.compareTo(s2) : s2.compareTo(s1);
            }

            @Override
            public boolean equals(Object obj) {
                return false;
            }
        });
    }

    public static void reorder(IRepositoryResource[] resources, final boolean parent2Child) {
        Arrays.sort(resources, new Comparator<IRepositoryResource>(){

            @Override
            public int compare(IRepositoryResource o1, IRepositoryResource o2) {
                String s1 = o1.getUrl();
                String s2 = o2.getUrl();
                return parent2Child ? s1.compareTo(s2) : s2.compareTo(s1);
            }

            @Override
            public boolean equals(Object obj) {
                return false;
            }
        });
    }

    public static boolean isHexDigit(char ch) {
        return Character.isDigit(ch) || Character.toUpperCase(ch) >= 'A' && Character.toUpperCase(ch) <= 'F';
    }

    private static int hexValue(char ch) {
        if (Character.isDigit(ch)) {
            return ch - 48;
        }
        ch = Character.toUpperCase(ch);
        return ch - 65 + 10;
    }

    public static String encodeURL(String url) {
        if (url == null) {
            return null;
        }
        int idx = (url = SVNUtility.normalizeURL(url)).startsWith("file:///") ? "file:///".length() : (url.startsWith("file://") ? url.indexOf("/", "file://".length()) + 1 : url.indexOf("://") + 3);
        if ((idx = url.indexOf("/", idx)) == -1) {
            return url;
        }
        Object retVal = url.substring(0, idx);
        String partToEncode = url.substring(idx);
        idx = ((String)retVal).indexOf(64);
        if (idx != -1) {
            String protocol = ((String)retVal).substring(0, ((String)retVal).indexOf("://") + 3);
            String serverPart = ((String)retVal).substring(idx);
            retVal = protocol + ((String)retVal).substring(protocol.length(), idx) + serverPart;
        }
        retVal = (String)retVal + SVNUtility.doEncode(partToEncode);
        return retVal;
    }

    public static String decodeURL(String url) {
        if (url == null) {
            return null;
        }
        int idx = (url = SVNUtility.normalizeURL(url)).startsWith("file:///") ? "file:///".length() : (url.startsWith("file://") ? url.indexOf("/", "file://".length()) + 1 : url.indexOf("://") + 3);
        if ((idx = url.indexOf("/", idx)) == -1) {
            return url;
        }
        Object retVal = url.substring(0, idx);
        String partToDecode = url.substring(idx);
        idx = ((String)retVal).indexOf(64);
        if (idx != -1) {
            String protocol = ((String)retVal).substring(0, ((String)retVal).indexOf("://") + 3);
            String serverPart = ((String)retVal).substring(idx);
            retVal = protocol + ((String)retVal).substring(protocol.length(), idx) + serverPart;
        }
        retVal = (String)retVal + SVNUtility.doDecode(partToDecode);
        return retVal;
    }

    protected static String doEncode(String src) {
        byte[] bytes;
        StringBuilder sb = null;
        try {
            bytes = src.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bytes = src.getBytes();
        }
        int i = 0;
        while (i < bytes.length) {
            int index = bytes[i] & 0xFF;
            if (uri_char_validity[index] > 0) {
                if (sb != null) {
                    sb.append((char)bytes[i]);
                }
            } else {
                if (sb == null) {
                    sb = new StringBuilder();
                    try {
                        sb.append(new String(bytes, 0, i, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        sb.append(new String(bytes, 0, i));
                    }
                }
                sb.append("%");
                sb.append(Character.toUpperCase(Character.forDigit((index & 0xF0) >> 4, 16)));
                sb.append(Character.toUpperCase(Character.forDigit(index & 0xF, 16)));
            }
            ++i;
        }
        return sb == null ? src : sb.toString();
    }

    protected static String doDecode(String src) {
        boolean query = false;
        boolean decoded = false;
        int length = src.length();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        int i = 0;
        while (i < length) {
            int ch = src.charAt(i);
            if (ch == 63) {
                query = true;
            } else if (ch == 43 && query) {
                ch = 32;
            } else if (ch == 37 && i + 2 < length && SVNUtility.isHexDigit(src.charAt(i + 1)) && SVNUtility.isHexDigit(src.charAt(i + 2))) {
                ch = (byte)(SVNUtility.hexValue(src.charAt(i + 1)) * 16 + SVNUtility.hexValue(src.charAt(i + 2)));
                decoded = true;
                i += 2;
            }
            bos.write(ch);
            ++i;
        }
        if (!decoded) {
            return src;
        }
        try {
            return new String(bos.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return src;
        }
    }

    public static String normalizeURL(String url) {
        String[] knownPrefixes;
        if (url == null) {
            return null;
        }
        int len = url.length();
        int st = 0;
        while (st < len && url.charAt(st) <= ' ') {
            ++st;
        }
        url = url.substring(st);
        String prefix = "";
        String[] stringArray = knownPrefixes = new String[]{"http://", "https://", "svn://", "svn+ssh://", "file:///", "file://", "^/", "../", "//", "/"};
        int n = knownPrefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (url.startsWith(element)) {
                prefix = element;
                url = url.substring(element.length());
                break;
            }
            ++n2;
        }
        StringTokenizer tokenizer = new StringTokenizer(PatternProvider.replaceAll(url, "([\\\\])+", "/"), "/", false);
        StringBuilder retVal = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            retVal.append((String)(retVal.length() == 0 ? token : "/" + token));
        }
        if (!"".equals(prefix)) {
            retVal.insert(0, prefix);
        }
        return retVal.toString();
    }

    public static Exception validateRepositoryLocation(IRepositoryLocation location, ISVNProgressMonitor monitor) {
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            try {
                proxy.listEntries(new SVNEntryRevisionReference(SVNUtility.encodeURL(location.getUrl()), null, null), SVNDepth.EMPTY, 0, 0L, entry -> {}, monitor);
            }
            catch (Exception e) {
                Exception exception = e;
                location.releaseSVNProxy(proxy);
                location.dispose();
                return exception;
            }
        }
        finally {
            location.releaseSVNProxy(proxy);
            location.dispose();
        }
        return null;
    }

    public static IProxyData getProxyData(String host, String type) {
        IProxyService proxyService = SVNTeamPlugin.instance().getProxyService();
        if (host != null && host.trim().length() > 0 && proxyService.isProxiesEnabled()) {
            try {
                URI uri = new URI(type, "//" + host, null);
                IProxyData[] proxyDatas = proxyService.select(uri);
                return proxyDatas != null && proxyDatas.length > 0 ? proxyDatas[0] : null;
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return null;
    }

    public static void configureProxy(ISVNConnector proxy, IRepositoryLocation location) {
        proxy.setUsername(location.getUsername());
        proxy.setPassword(location.getPassword());
        location.getSSLSettings();
        String host = "localhost";
        String protocol = "file";
        try {
            URL url = SVNUtility.getSVNUrl(location.getUrl());
            protocol = url.getProtocol();
            if (!protocol.equals("file")) {
                host = url.getHost();
            }
        }
        catch (MalformedURLException malformedURLException) {}
        String proxyType = protocol.equals("https") ? "HTTPS" : "HTTP";
        SVNRemoteStorage.instance().getProxyCredentialsManager();
        SVNUtility.getProxyData(host, proxyType);
    }

    public static SVNChangeStatus getSVNInfoForNotConnected(IResource root) {
        IPath checkedPath;
        IPath location = FileUtility.getResourcePath(root);
        IPath iPath = checkedPath = root.getType() == 1 ? location.removeLastSegments(1) : location;
        if (SVNUtility.isPriorToSVN17() && !checkedPath.append(SVNUtility.getSVNFolderName()).toFile().exists()) {
            return null;
        }
        ISVNConnector proxy = CoreExtensionsManager.instance().getSVNConnectorFactory().createConnector();
        try {
            SVNChangeStatus[] st = SVNUtility.status(proxy, location.toString(), SVNDepth.IMMEDIATES, 128L, new SVNNullProgressMonitor());
            if (st != null && st.length > 0) {
                SVNUtility.reorder(st, true);
                SVNChangeStatus sVNChangeStatus = st[0].url == null ? null : st[0];
                return sVNChangeStatus;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
        finally {
            proxy.dispose();
        }
    }

    public static String getPropertyForNotConnected(IResource root, String propertyName) {
        String location = FileUtility.getWorkingCopyPath(root);
        ISVNConnector proxy = CoreExtensionsManager.instance().getSVNConnectorFactory().createConnector();
        try {
            SVNProperty data = proxy.getProperty(new SVNEntryRevisionReference(location, null, SVNRevision.WORKING), propertyName, null, new SVNNullProgressMonitor());
            String string = data == null ? null : data.value;
            return string;
        }
        catch (Exception exception) {
            return null;
        }
        finally {
            proxy.dispose();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isIgnored(IResource resource) {
        if (FileUtility.isNotSupervised(resource)) return true;
        if (resource.isDerived(512)) {
            if (!CoreExtensionsManager.instance().getOptionProvider().is("commitDerivedEnabled")) return true;
        }
        if (Team.isIgnoredHint((IResource)resource)) return true;
        if (SVNUtility.isMergeParts(resource)) {
            return true;
        }
        try {
            IIgnoreRecommendations[] iIgnoreRecommendationsArray = CoreExtensionsManager.instance().getIgnoreRecommendations();
            int n = iIgnoreRecommendationsArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IIgnoreRecommendations ignore = iIgnoreRecommendationsArray[n2];
                if (ignore.isAcceptableNature(resource) && ignore.isIgnoreRecommended(resource)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Map<IProject, List<IResource>> splitWorkingCopies(IResource[] resources) {
        HashMap<IProject, List<IResource>> wc2Resources = new HashMap<IProject, List<IResource>>();
        ISVNConnector proxy = CoreExtensionsManager.instance().getSVNConnectorFactory().createConnector();
        try {
            HashMap<File, IProject> roots = new HashMap<File, IProject>();
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                ArrayList<IResource> wcResources;
                IResource element = iResourceArray[n2];
                IProject wcRoot = element.getProject();
                File tFile = FileUtility.getResourcePath((IResource)wcRoot).toFile();
                Object[] realRoot = SVNUtility.getWCRoot(proxy, tFile, SVNUtility.getSVNInfo(tFile, proxy));
                IProject tRoot = (IProject)roots.get(realRoot[0]);
                if (tRoot == null) {
                    tRoot = wcRoot;
                    roots.put((File)realRoot[0], tRoot);
                }
                if ((wcResources = (ArrayList<IResource>)wc2Resources.get(wcRoot = tRoot)) == null) {
                    wcResources = new ArrayList<IResource>();
                    wc2Resources.put(wcRoot, wcResources);
                }
                wcResources.add(element);
                ++n2;
            }
        }
        finally {
            proxy.dispose();
        }
        return wc2Resources;
    }

    public static Map splitWorkingCopies(File[] files) {
        HashMap wc2Resources = new HashMap();
        ISVNConnector proxy = CoreExtensionsManager.instance().getSVNConnectorFactory().createConnector();
        try {
            HashMap<File, SVNEntryInfo> file2info = new HashMap<File, SVNEntryInfo>();
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                file2info.put(file, SVNUtility.getSVNInfo(file, proxy));
                ++n2;
            }
            ArrayList<File> restOfFiles = new ArrayList<File>(Arrays.asList(files));
            while (restOfFiles.size() > 0) {
                SVNEntryInfo info;
                File current = restOfFiles.get(0);
                Object[] wcRoot = SVNUtility.getWCRoot(proxy, current, info = (SVNEntryInfo)file2info.get(current));
                ArrayList<File> wcResources = (ArrayList<File>)wc2Resources.get(wcRoot[0]);
                if (wcResources == null) {
                    wcResources = new ArrayList<File>();
                    wc2Resources.put(wcRoot[0], wcResources);
                }
                Path rootPath = new Path(((File)wcRoot[0]).getAbsolutePath());
                IPath rootInfoPath = SVNUtility.createPathForSVNUrl(((SVNEntryInfo)wcRoot[1]).url);
                Iterator<File> it = restOfFiles.iterator();
                while (it.hasNext()) {
                    File checked = it.next();
                    if (!rootPath.isPrefixOf((IPath)new Path(checked.getAbsolutePath())) || !rootInfoPath.isPrefixOf(SVNUtility.createPathForSVNUrl(((SVNEntryInfo)file2info.get((Object)checked)).url))) continue;
                    wcResources.add(checked);
                    it.remove();
                }
            }
        }
        finally {
            proxy.dispose();
        }
        return wc2Resources;
    }

    private static Object[] getWCRoot(ISVNConnector proxy, File node, SVNEntryInfo info) {
        File oldRoot = node;
        SVNEntryInfo oldInfo = info;
        node = node.getParentFile();
        while (node != null) {
            SVNEntryInfo rootInfo = SVNUtility.getSVNInfo(node, proxy);
            if (rootInfo != null) {
                if (oldInfo == null) {
                    oldInfo = rootInfo;
                } else if (!SVNUtility.createPathForSVNUrl(rootInfo.url).isPrefixOf(SVNUtility.createPathForSVNUrl(oldInfo.url))) {
                    return new Object[]{oldRoot, oldInfo};
                }
                oldRoot = node;
            } else if (oldInfo != null) {
                return new Object[]{oldRoot, oldInfo};
            }
            node = node.getParentFile();
        }
        if (oldInfo == null) {
            SVNUtility.getSVNInfo(oldRoot, proxy, true);
            String errMessage = SVNMessages.formatErrorString("Error_NonSVNPath", new String[]{oldRoot.getAbsolutePath()});
            throw new RuntimeException(errMessage);
        }
        return new Object[]{oldRoot, oldInfo};
    }

    public static SVNEntryInfo getSVNInfo(File root) {
        ISVNConnector proxy = CoreExtensionsManager.instance().getSVNConnectorFactory().createConnector();
        try {
            SVNEntryInfo sVNEntryInfo = SVNUtility.getSVNInfo(root, proxy);
            return sVNEntryInfo;
        }
        finally {
            proxy.dispose();
        }
    }

    public static SVNEntryInfo getSVNInfo(File root, ISVNConnector proxy) {
        return SVNUtility.getSVNInfo(root, proxy, false);
    }

    public static SVNEntryInfo getSVNInfo(File root, ISVNConnector proxy, boolean reportException) {
        block4: {
            if (root.exists()) {
                File svnMeta = root.isDirectory() ? root : root.getParentFile();
                svnMeta = new File(svnMeta.getAbsolutePath() + "/" + SVNUtility.getSVNFolderName());
                if (!SVNUtility.isPriorToSVN17() || svnMeta.exists()) {
                    try {
                        SVNEntryInfo[] st = SVNUtility.info(proxy, new SVNEntryRevisionReference(root.getAbsolutePath()), SVNDepth.EMPTY, new SVNNullProgressMonitor());
                        return st != null && st.length != 0 ? st[0] : null;
                    }
                    catch (Exception ex) {
                        if (!reportException) break block4;
                        throw new RuntimeException(ex);
                    }
                }
            }
        }
        return null;
    }

    public static String[] asURLArray(IRepositoryResource[] resources, boolean encode) {
        String[] retVal = new String[resources.length];
        int i = 0;
        while (i < resources.length) {
            retVal[i] = encode ? SVNUtility.encodeURL(resources[i].getUrl()) : resources[i].getUrl();
            ++i;
        }
        return retVal;
    }

    public static Map splitRepositoryLocations(IRepositoryResource[] resources) throws Exception {
        HashMap<IRepositoryLocation, ArrayList<IRepositoryResource>> repository2Resources = new HashMap<IRepositoryLocation, ArrayList<IRepositoryResource>>();
        IRepositoryResource[] iRepositoryResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryResource element = iRepositoryResourceArray[n2];
            IRepositoryLocation location = element.getRepositoryLocation();
            ArrayList<IRepositoryResource> tResources = (ArrayList<IRepositoryResource>)repository2Resources.get(location);
            if (tResources == null) {
                tResources = new ArrayList<IRepositoryResource>();
                repository2Resources.put(location, tResources);
            }
            tResources.add(element);
            ++n2;
        }
        return SVNUtility.combineLocationsByUUID(repository2Resources);
    }

    public static Map splitRepositoryLocations(IResource[] resources) throws Exception {
        HashMap<IRepositoryLocation, ArrayList<IResource>> repository2Resources = new HashMap<IRepositoryLocation, ArrayList<IResource>>();
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            IRepositoryLocation location = storage.getRepositoryLocation(element);
            ArrayList<IResource> tResources = (ArrayList<IResource>)repository2Resources.get(location);
            if (tResources == null) {
                tResources = new ArrayList<IResource>();
                repository2Resources.put(location, tResources);
            }
            tResources.add(element);
            ++n2;
        }
        return SVNUtility.combineLocationsByUUID(repository2Resources);
    }

    public static Map splitRepositoryLocations(File[] files) throws Exception {
        HashMap<IRepositoryLocation, ArrayList<File>> repository2Resources = new HashMap<IRepositoryLocation, ArrayList<File>>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            IRepositoryResource resource = SVNFileStorage.instance().asRepositoryResource(file, false);
            IRepositoryLocation location = resource.getRepositoryLocation();
            ArrayList<File> tResources = (ArrayList<File>)repository2Resources.get(location);
            if (tResources == null) {
                tResources = new ArrayList<File>();
                repository2Resources.put(location, tResources);
            }
            tResources.add(file);
            ++n2;
        }
        return SVNUtility.combineLocationsByUUID(repository2Resources);
    }

    public static SVNEntry.Kind getNodeKind(String path, SVNEntry.Kind kind, boolean ignoreNone) {
        if (kind == SVNEntry.Kind.DIR || kind == SVNEntry.Kind.FILE || kind == SVNEntry.Kind.SYMLINK) {
            return kind;
        }
        if (kind == SVNEntry.Kind.NONE || kind == SVNEntry.Kind.UNKNOWN) {
            File f = new File(path);
            if (f.exists()) {
                try {
                    IFileStore store = EFS.getStore((URI)f.toURI());
                    IFileInfo info = store.fetchInfo();
                    if (info.getAttribute(32)) {
                        return SVNEntry.Kind.SYMLINK;
                    }
                }
                catch (CoreException coreException) {}
                return f.isDirectory() ? SVNEntry.Kind.DIR : SVNEntry.Kind.FILE;
            }
            if (ignoreNone) {
                return SVNEntry.Kind.NONE;
            }
        }
        String errMessage = BaseMessages.format("Error_UnrecognizedNodeKind", new String[]{String.valueOf((Object)kind), path});
        throw new RuntimeException(errMessage);
    }

    public static IRepositoryResource[] shrinkChildNodes(IRepositoryResource[] resources) {
        HashSet<IRepositoryResource> roots = new HashSet<IRepositoryResource>(Arrays.asList(resources));
        IRepositoryResource[] iRepositoryResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryResource element = iRepositoryResourceArray[n2];
            if (SVNUtility.hasRoots(roots, element)) {
                roots.remove(element);
            }
            ++n2;
        }
        return roots.toArray(new IRepositoryResource[roots.size()]);
    }

    public static IRepositoryResource[] getCommonParents(IRepositoryResource[] resources) {
        HashMap<IRepositoryResource, ArrayList<IRepositoryResource>> byRepositoryRoots = new HashMap<IRepositoryResource, ArrayList<IRepositoryResource>>();
        IRepositoryResource[] iRepositoryResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryResource element = iRepositoryResourceArray[n2];
            IRepositoryResource root = element.getRoot();
            ArrayList<IRepositoryResource> tmp = (ArrayList<IRepositoryResource>)byRepositoryRoots.get(root);
            if (tmp == null) {
                tmp = new ArrayList<IRepositoryResource>();
                byRepositoryRoots.put(root, tmp);
            }
            tmp.add(element);
            ++n2;
        }
        HashSet<IRepositoryResource> container = new HashSet<IRepositoryResource>();
        for (ArrayList tmp : byRepositoryRoots.values()) {
            IRepositoryResource parent = SVNUtility.getCommonParent(tmp.toArray(new IRepositoryResource[tmp.size()]));
            if (parent == null) continue;
            container.add(parent);
        }
        return container.toArray(new IRepositoryResource[container.size()]);
    }

    public static String getAscendant(IRepositoryResource resource) {
        String pathUpToRoot = SVNUtility.getPathUpToRoot(resource);
        int idx = pathUpToRoot.indexOf(47);
        return idx == -1 ? pathUpToRoot : pathUpToRoot.substring(0, idx);
    }

    public static String getDescendant(IRepositoryResource resource) {
        String pathUpToRoot = SVNUtility.getPathUpToRoot(resource);
        int idx = pathUpToRoot.lastIndexOf(47);
        return idx == -1 ? pathUpToRoot : pathUpToRoot.substring(idx + 1);
    }

    public static String getPathUpToRoot(IRepositoryResource resource) {
        IRepositoryResource root = resource.getRoot();
        return root == resource ? resource.getName() : resource.getUrl().substring(root.getUrl().length() + 1);
    }

    public static int compareRevisions(SVNRevision first, SVNRevision second, SVNEntryRevisionReference referenceFirst, SVNEntryRevisionReference referenceSecond, ISVNConnector proxy) throws SVNConnectorException {
        SVNEntryInfo[] entryInfo;
        if (first.getKind() == SVNRevision.Kind.NUMBER && second.getKind() == SVNRevision.Kind.NUMBER) {
            SVNRevision.Number fromNumber = (SVNRevision.Number)first;
            SVNRevision.Number toNumber = (SVNRevision.Number)second;
            return fromNumber.getNumber() > toNumber.getNumber() ? 1 : (fromNumber.getNumber() == toNumber.getNumber() ? 0 : -1);
        }
        SVNRevision.Date fromDate = null;
        SVNRevision.Date toDate = null;
        if (first.getKind() == SVNRevision.Kind.DATE) {
            fromDate = (SVNRevision.Date)first;
        } else {
            entryInfo = SVNUtility.info(proxy, referenceFirst, SVNDepth.UNKNOWN, new SVNNullProgressMonitor());
            fromDate = SVNRevision.fromDate(entryInfo[0].lastChangedDate);
        }
        if (second.getKind() == SVNRevision.Kind.DATE) {
            toDate = (SVNRevision.Date)second;
        } else {
            entryInfo = SVNUtility.info(proxy, referenceSecond, SVNDepth.UNKNOWN, new SVNNullProgressMonitor());
            toDate = SVNRevision.fromDate(entryInfo[0].lastChangedDate);
        }
        return fromDate.getDate() > toDate.getDate() ? 1 : (fromDate.getDate() == toDate.getDate() ? 0 : -1);
    }

    private static boolean isMergeParts(IResource resource) {
        String ext = resource.getFileExtension();
        return ext != null && MERGE_PART.matcher(ext).matches();
    }

    private static Map combineLocationsByUUID(Map repository2Resources) throws Exception {
        Map.Entry entry;
        Map.Entry element;
        HashMap locationUtility2Resources = new HashMap();
        Iterator iterator = repository2Resources.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element = iterator.next();
            IRepositoryLocation location = (IRepositoryLocation)entry.getKey();
            List tResources = (List)entry.getValue();
            RepositoryLocationUtility locationUtility = new RepositoryLocationUtility(location);
            ArrayList tResources2 = (ArrayList)locationUtility2Resources.get(locationUtility);
            if (tResources2 == null) {
                tResources2 = new ArrayList();
                locationUtility2Resources.put(locationUtility, tResources2);
            }
            tResources2.addAll(tResources);
        }
        repository2Resources.clear();
        iterator = locationUtility2Resources.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element = iterator.next();
            RepositoryLocationUtility locationUtility = (RepositoryLocationUtility)entry.getKey();
            repository2Resources.put(locationUtility.location, entry.getValue());
        }
        return repository2Resources;
    }

    private static boolean hasRoots(Set<IRepositoryResource> roots, IRepositoryResource node) {
        while ((node = node.getParent()) != null) {
            if (!roots.contains(node)) continue;
            return true;
        }
        return false;
    }

    private static IRepositoryResource getCommonParent(IRepositoryResource[] resources) {
        if (resources == null || resources.length == 0) {
            return null;
        }
        IRepositoryResource base = resources[0].getParent();
        while (base != null) {
            int startsCnt = 0;
            IPath baseUrl = SVNUtility.createPathForSVNUrl(base.getUrl());
            IRepositoryResource[] iRepositoryResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IRepositoryResource element = iRepositoryResourceArray[n2];
                if (baseUrl.isPrefixOf(SVNUtility.createPathForSVNUrl(element.getUrl()))) {
                    ++startsCnt;
                }
                ++n2;
            }
            if (startsCnt == resources.length) break;
            base = base.getParent();
        }
        return base;
    }

    private static IRepositoryRoot getRootLocation(IRepositoryResource resource, String rootName, int kind) {
        IRepositoryLocation location = resource.getRepositoryLocation();
        IRepositoryRoot root = (IRepositoryRoot)resource.getRoot();
        if (!location.isStructureEnabled() || root.getName().equals(rootName)) {
            return root;
        }
        IRepositoryContainer retVal = null;
        int rootKind = root.getKind();
        IRepositoryResource parent = root.getParent();
        if (rootKind == 4 || parent == null) {
            retVal = root.asRepositoryContainer(rootName, false);
        } else if (rootKind == 0) {
            IRepositoryRoot tmp = (IRepositoryRoot)parent.getRoot();
            if (root.getName().equals(location.getTrunkLocation()) || root.getName().equals(location.getBranchesLocation()) || root.getName().equals(location.getTagsLocation())) {
                retVal = parent.asRepositoryContainer(rootName, false);
            } else if (tmp.getKind() == 4) {
                retVal = root.asRepositoryContainer(rootName, false);
            }
            root = tmp;
        }
        if (retVal == null) {
            IRepositoryResource rootParent = root.getParent();
            retVal = rootParent.asRepositoryContainer(rootName, false);
        }
        if (!(retVal instanceof IRepositoryRoot) || ((IRepositoryRoot)retVal).getKind() != kind) {
            throw new RuntimeException("Resource " + resource.getUrl() + " rootName " + rootName + " detected root " + String.valueOf(rootKind) + " " + root.getUrl() + " location URL " + location.getUrl() + " retVal " + retVal.getUrl());
        }
        return (IRepositoryRoot)retVal;
    }

    public static IProject[] getTagOperatedProjects(IResource[] resources) {
        HashSet<IProject> operatedProjects = new HashSet<IProject>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            SVNTeamProvider provider;
            IResource element = iResourceArray[n2];
            IProject project = element.getProject();
            if (project != null && !operatedProjects.contains(project) && (provider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.team.svn.core.svnnature")) != null && provider.isVerifyTagOnCommit() && ((IRepositoryRoot)SVNRemoteStorage.instance().asRepositoryResource(element).getRoot()).getKind() == 3) {
                operatedProjects.add(project);
            }
            ++n2;
        }
        return operatedProjects.toArray(new IProject[0]);
    }

    public static String getDepthArg(SVNDepth depth, long options) {
        String depthArg;
        String string = depthArg = (options & 0x4000L) != 0L ? " --set-depth " : " --depth ";
        if (depth == SVNDepth.EMPTY) {
            return depthArg + "empty ";
        }
        if (depth == SVNDepth.INFINITY) {
            return depthArg + "infinity";
        }
        if (depth == SVNDepth.IMMEDIATES) {
            return depthArg + "immediates ";
        }
        if (depth == SVNDepth.UNKNOWN) {
            return "";
        }
        if (depth == SVNDepth.EXCLUDE) {
            return depthArg + "exclude ";
        }
        return depthArg + "files ";
    }

    public static String getIgnoreExternalsArg(long options) {
        return ISVNConnector.Options.asCommandLine(options);
    }

    public static IPath createPathForSVNUrl(String fullPath) {
        return fullPath == null ? null : new PathForURL(fullPath, true);
    }

    private SVNUtility() {
    }

    public static class SVNExternalPropertyData {
        public String localPath;
        public String url;
        public String revision;
        public String pegRevision;
        public boolean isNewFormat;

        public SVNExternalPropertyData(String localPath, String url, String pegRevision, String revision, boolean isNewFormat) {
            this.isNewFormat = isNewFormat;
            this.localPath = localPath;
            this.pegRevision = pegRevision;
            this.revision = revision;
            this.url = url;
        }

        private static String[] splitExternalOnParts(String str, boolean isCheckSpacesInLocalPath) {
            if (str == null) {
                return new String[0];
            }
            str = str.trim();
            if (!isCheckSpacesInLocalPath) {
                return str.trim().split("[\\t ]+");
            }
            ArrayList<String> parts = new ArrayList<String>();
            StringBuilder tmpString = new StringBuilder();
            boolean hasQuote = false;
            int i = 0;
            while (i < str.length()) {
                char ch = str.charAt(i);
                if (ch == '\'' || ch == '\"') {
                    hasQuote = !hasQuote;
                } else if (ch == ' ' || ch == '\t') {
                    if (hasQuote) {
                        tmpString.append(ch);
                    } else if (tmpString.length() > 0) {
                        parts.add(tmpString.toString());
                        tmpString.setLength(0);
                    }
                } else if (ch == '\\' && i + 1 < str.length() - 1 && str.charAt(i + 1) == ' ') {
                    tmpString.append(' ');
                    ++i;
                } else {
                    tmpString.append(ch);
                }
                ++i;
            }
            parts.add(tmpString.toString());
            return parts.toArray(new String[0]);
        }

        public static String serialize(SVNExternalPropertyData[] data) {
            Object retVal = "";
            SVNExternalPropertyData[] sVNExternalPropertyDataArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                SVNExternalPropertyData entry = sVNExternalPropertyDataArray[n2];
                retVal = (String)retVal + entry.toString() + "\n";
                ++n2;
            }
            return retVal;
        }

        public static SVNExternalPropertyData[] parse(String property) {
            String[] externals;
            if (property == null) {
                return new SVNExternalPropertyData[0];
            }
            ArrayList<SVNExternalPropertyData> resList = new ArrayList<SVNExternalPropertyData>();
            String[] stringArray = externals = property.trim().split("[\\n|\\r\\n]+");
            int n = externals.length;
            int n2 = 0;
            while (n2 < n) {
                String external = stringArray[n2];
                if (!external.startsWith("#")) {
                    boolean isCheckSpacesInLocalPath = CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() >= 6;
                    String[] parts = SVNExternalPropertyData.splitExternalOnParts(external, isCheckSpacesInLocalPath);
                    if (parts.length < 2 || parts.length > 4) {
                        throw new UnreportableException("Malformed external, " + parts.length + ", " + external);
                    }
                    String name = null;
                    String url = null;
                    String revision = null;
                    String pegRevision = null;
                    boolean isNewFormat = false;
                    if (SVNUtility.isValidSVNURL(parts[parts.length - 1])) {
                        isNewFormat = false;
                        name = parts[0];
                        url = parts[1];
                        if (parts.length == 4) {
                            revision = parts[2];
                            url = parts[3];
                        } else if (parts.length == 3) {
                            revision = parts[1].substring(2);
                            url = parts[2];
                        }
                    } else {
                        isNewFormat = true;
                        name = parts[parts.length - 1];
                        url = parts[0];
                        if (parts.length == 4) {
                            revision = parts[1];
                            url = parts[2];
                        } else if (parts.length == 3) {
                            revision = parts[0].substring(2);
                            url = parts[1];
                        }
                        int idx = url.lastIndexOf(64);
                        if (idx != -1) {
                            pegRevision = url.substring(idx + 1);
                            url = url.substring(0, idx);
                        }
                    }
                    SVNExternalPropertyData data = new SVNExternalPropertyData(name, url, pegRevision, revision, isNewFormat);
                    resList.add(data);
                }
                ++n2;
            }
            return resList.toArray(new SVNExternalPropertyData[0]);
        }

        public String toString() {
            Object localPath = this.localPath;
            if (((String)localPath).contains(" ")) {
                localPath = "\"" + (String)localPath + "\"";
            }
            StringBuilder res = new StringBuilder();
            if (this.isNewFormat) {
                if (this.revision != null) {
                    res.append("-r").append(this.revision).append("\t");
                }
                res.append(this.url);
                if (this.pegRevision != null) {
                    res.append("@").append(this.pegRevision);
                }
                res.append("\t").append((String)localPath);
            } else {
                res.append((String)localPath).append("\t");
                if (this.revision != null) {
                    res.append("-r").append(this.revision).append("\t");
                }
                res.append(this.url);
            }
            return res.toString();
        }
    }
}

