/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.synchronize.variant;

import org.eclipse.team.core.variants.CachedResourceVariant;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.SVNEntryInfo;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRemoteStorage;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public abstract class ResourceVariant
extends CachedResourceVariant {
    protected ILocalResource local;

    public ResourceVariant(ILocalResource local) {
        this.local = local;
    }

    public ILocalResource getResource() {
        return this.local;
    }

    protected String getCachePath() {
        IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(this.local.getResource());
        return location.getId() + this.local.getResource().getFullPath().toString() + " " + this.getContentIdentifier();
    }

    protected String getCacheId() {
        return IRemoteStorage.class.getName();
    }

    public String getName() {
        return this.local.getName();
    }

    public byte[] asBytes() {
        return this.getContentIdentifier().getBytes();
    }

    public String getStatus() {
        return this.local.getStatus();
    }

    public String getContentIdentifier() {
        SVNEntryInfo[] st;
        long revision = this.local.getRevision();
        if (revision == -1L && (IStateFilter.SF_ONREPOSITORY.accept(this.local) || this.local.isCopied()) && (st = SVNUtility.info(new SVNEntryRevisionReference(FileUtility.getWorkingCopyPath(this.local.getResource())))) != null && st.length > 0) {
            long l = revision = this.local.isCopied() ? st[0].copyFromRevision : st[0].lastChangedRevision;
        }
        if (revision == -1L) {
            if (this.isNotOnRepository()) {
                return SVNMessages.ResourceVariant_unversioned;
            }
            if (IStateFilter.SF_DELETED.accept(this.local)) {
                return SVNMessages.ResourceVariant_deleted;
            }
        }
        return String.valueOf(revision);
    }

    protected boolean isNotOnRepository() {
        return IStateFilter.SF_UNVERSIONED.accept(this.local);
    }
}

