/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.svnstorage;

import org.eclipse.core.resources.IResource;
import org.eclipse.team.svn.core.connector.SVNConflictDescriptor;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;

public abstract class SVNLocalResource
implements ILocalResource {
    protected IResource resource;
    protected long revision;
    protected long baseRevision;
    protected String textStatus;
    protected String propStatus;
    protected int changeMask;
    protected String author;
    protected long lastCommitDate;
    protected SVNConflictDescriptor treeConflictDescriptor;

    protected SVNLocalResource(IResource resource, long revision, long baseRevision, String textStatus, String propStatus, int changeMask, String author, long lastCommitDate, SVNConflictDescriptor treeConflictDescriptor) {
        this.resource = resource;
        this.revision = revision;
        this.baseRevision = baseRevision;
        this.textStatus = textStatus;
        this.propStatus = propStatus;
        this.changeMask = changeMask;
        this.author = author != null ? author.intern() : null;
        this.lastCommitDate = lastCommitDate;
        this.treeConflictDescriptor = treeConflictDescriptor;
    }

    @Override
    public boolean isLocked() {
        return (this.changeMask & 0x10) != 0;
    }

    @Override
    public IResource getResource() {
        return this.resource;
    }

    @Override
    public String getName() {
        return this.resource.getName();
    }

    @Override
    public long getRevision() {
        return this.revision;
    }

    @Override
    public long getBaseRevision() {
        return this.baseRevision;
    }

    @Override
    public String getTextStatus() {
        return this.textStatus;
    }

    @Override
    public String getPropStatus() {
        return this.propStatus;
    }

    @Override
    public String getStatus() {
        return SVNRemoteStorage.getCompoundStatusString(this.textStatus, this.propStatus);
    }

    @Override
    public int getChangeMask() {
        return this.changeMask;
    }

    @Override
    public boolean isCopied() {
        return (this.changeMask & 4) != 0;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public long getLastCommitDate() {
        return this.lastCommitDate;
    }

    @Override
    public boolean hasTreeConflict() {
        return this.treeConflictDescriptor != null && this.treeConflictDescriptor.conflictKind == SVNConflictDescriptor.Kind.TREE;
    }

    @Override
    public SVNConflictDescriptor getTreeConflictDescriptor() {
        return this.treeConflictDescriptor;
    }

    public String toString() {
        return this.resource.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ILocalResource) {
            return this.resource.equals((Object)((ILocalResource)obj).getResource());
        }
        return false;
    }
}

