/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote.management;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRevisionLink;
import org.eclipse.team.svn.core.resource.IRevisionLinkProvider;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class AddRevisionLinkOperation
extends AbstractActionOperation {
    private IRevisionLink[] links;
    private IRevisionLinkProvider provider;
    protected SVNRevision revision;

    public AddRevisionLinkOperation(IRevisionLink link, long revision) {
        this(link, (SVNRevision)SVNRevision.fromNumber(revision));
    }

    public AddRevisionLinkOperation(IRevisionLink link, SVNRevision revision) {
        this();
        this.links = new IRevisionLink[]{link};
        this.revision = revision;
    }

    public AddRevisionLinkOperation(IRevisionLinkProvider provider, long revision) {
        this(provider, (SVNRevision)SVNRevision.fromNumber(revision));
    }

    public AddRevisionLinkOperation(IRevisionLinkProvider provider, SVNRevision revision) {
        this();
        this.provider = provider;
        this.revision = revision;
    }

    public AddRevisionLinkOperation() {
        super("Operation_AddRevisionLink", SVNMessages.class);
    }

    protected IRevisionLink[] operableData() {
        return this.links == null ? this.provider.getRevisionLinks() : this.links;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRevisionLink[] links = this.operableData();
        int i = 0;
        while (i < links.length && !monitor.isCanceled()) {
            IRevisionLink source = links[i];
            this.protectStep(monitor1 -> {
                SVNRevision pegRevision;
                SVNRevision selectedRevision;
                IRepositoryResource sourceResource = source.getRepositoryResource();
                IRepositoryLocation location = sourceResource.getRepositoryLocation();
                IRepositoryResource targetResource = SVNUtility.copyOf(sourceResource);
                SVNRevision sVNRevision = selectedRevision = this.revision == null ? sourceResource.getSelectedRevision() : this.revision;
                if (selectedRevision.equals(SVNRevision.HEAD)) {
                    long revision = sourceResource.getRevision();
                    if (revision == -1L) {
                        return;
                    }
                    selectedRevision = SVNRevision.fromNumber(revision);
                }
                if ((pegRevision = sourceResource.getPegRevision()).equals(SVNRevision.HEAD)) {
                    long revision = location.getRepositoryRoot().getRevision();
                    if (revision == -1L) {
                        return;
                    }
                    pegRevision = SVNRevision.fromNumber(revision);
                }
                targetResource.setSelectedRevision(selectedRevision);
                targetResource.setPegRevision(pegRevision);
                IRevisionLink link = SVNUtility.createRevisionLink(targetResource);
                link.setComment(source.getComment());
                location.addRevisionLink(link);
            }, monitor, links.length);
            ++i;
        }
    }
}

