/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNImportFilterCallback;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.operation.IRevisionProvider;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class ImportOperation
extends AbstractRepositoryOperation
implements IRevisionProvider {
    protected String path;
    protected String message;
    protected SVNDepth depth;
    protected IRevisionProvider.RevisionPair[] revisionPair;
    protected ISVNImportFilterCallback filter;

    public ImportOperation(IRepositoryResource resource, String path, String message, SVNDepth depth) {
        this(resource, path, message, depth, null);
    }

    public ImportOperation(IRepositoryResource resource, String path, String message, SVNDepth depth, ISVNImportFilterCallback filter) {
        super("Operation_Import", SVNMessages.class, new IRepositoryResource[]{resource});
        this.path = path;
        this.message = message;
        this.depth = depth;
        this.filter = filter;
    }

    @Override
    public IRevisionProvider.RevisionPair[] getRevisions() {
        return this.revisionPair;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource resource = this.operableData()[0];
        IRepositoryLocation location = resource.getRepositoryLocation();
        this.revisionPair = new IRevisionProvider.RevisionPair[1];
        ISVNConnector proxy = location.acquireSVNProxy();
        ISVNNotificationCallback notify = info -> {
            if (info.revision != -1L) {
                String[] path = new String[]{resource.getUrl()};
                this.revisionPair[0] = new IRevisionProvider.RevisionPair(info.revision, path, location);
                String message = BaseMessages.format(SVNMessages.Console_CommittedRevision, new String[]{String.valueOf(info.revision)});
                this.writeToConsole(1, message);
            }
        };
        try {
            SVNUtility.addSVNNotifyListener(proxy, notify);
            this.writeToConsole(0, "svn import \"" + FileUtility.normalizePath(this.path) + "\" \"" + SVNUtility.getDepthArg(this.depth, 0L) + ISVNConnector.Options.asCommandLine(4352L) + " -m \"" + this.message + "\"" + FileUtility.getUsernameParam(location.getUsername()) + "\n");
            proxy.importTo(this.path, SVNUtility.encodeURL(resource.getUrl()), this.message, this.depth, 4352L, null, this.filter, new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            SVNUtility.removeSVNNotifyListener(proxy, notify);
            location.releaseSVNProxy(proxy);
        }
    }

    @Override
    protected String getShortErrorMessage(Throwable t) {
        return BaseMessages.format(super.getShortErrorMessage(t), new Object[]{this.operableData()[0].getUrl()});
    }
}

