/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local.management;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.SVNResourceRuleFactory;
import org.eclipse.team.svn.core.utility.FileUtility;

public class DisconnectOperation
extends AbstractActionOperation {
    protected IProject[] projects;
    protected boolean dropSVNFolders;

    public DisconnectOperation(IProject[] projects, boolean dropSVNFolders) {
        super("Operation_Disconnect", SVNMessages.class);
        this.projects = projects;
        this.dropSVNFolders = dropSVNFolders;
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        HashSet<ISchedulingRule> rules = new HashSet<ISchedulingRule>();
        IProject[] iProjectArray = this.projects;
        int n = this.projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            rules.add(SVNResourceRuleFactory.INSTANCE.modifyRule((IResource)project));
            ++n2;
        }
        return new MultiRule(rules.toArray(new ISchedulingRule[rules.size()]));
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IProject[] iProjectArray = this.projects;
        int n = this.projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject current = iProjectArray[n2];
            this.protectStep(monitor1 -> {
                if (RepositoryProvider.isShared((IProject)current)) {
                    RepositoryProvider.unmap((IProject)current);
                }
                if (this.dropSVNFolders) {
                    FileUtility.removeSVNMetaInformation((IResource)current, null);
                }
            }, monitor, this.projects.length);
            ++n2;
        }
    }
}

