/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local.management;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public class CleanupOperation
extends AbstractWorkingCopyOperation {
    public CleanupOperation(IResource[] resources) {
        super("Operation_CleanupResources", SVNMessages.class, resources);
    }

    public CleanupOperation(IResourceProvider provider) {
        super("Operation_CleanupResources", SVNMessages.class, provider);
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        int i = 0;
        while (i < resources.length) {
            IRepositoryLocation location = storage.getRepositoryLocation(resources[i]);
            String wcPath = FileUtility.getWorkingCopyPath(resources[i]);
            ISVNConnector proxy = location.acquireSVNProxy();
            ProgressMonitorUtility.setTaskInfo(monitor, this, resources[i].getName());
            this.writeToConsole(0, "svn cleanup \"" + FileUtility.normalizePath(wcPath) + "\"\n");
            this.protectStep(monitor1 -> proxy.cleanup(wcPath, 0x78000000000L, new SVNProgressMonitor(this, monitor1, null)), monitor, resources.length);
            location.releaseSVNProxy(proxy);
            ProgressMonitorUtility.progress(monitor, i, resources.length);
            ++i;
        }
    }
}

