/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local.change.visitors;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.local.change.IActionOperationProcessor;
import org.eclipse.team.svn.core.operation.local.change.IResourceChangeVisitor;
import org.eclipse.team.svn.core.operation.local.change.ResourceChange;
import org.eclipse.team.svn.core.resource.ILocalFile;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.utility.FileUtility;

public class SaveContentVisitor
implements IResourceChangeVisitor {
    @Override
    public void preVisit(ResourceChange change, IActionOperationProcessor processor, IProgressMonitor monitor) throws Exception {
        ILocalResource local = change.getLocal();
        if (local instanceof ILocalFile) {
            if (IStateFilter.SF_DELETED.accept(local) && !IStateFilter.SF_PREREPLACEDREPLACED.accept(local) || IStateFilter.SF_UNVERSIONED.accept(local) && "dir_conflicts.prej".equals(local.getName())) {
                return;
            }
            File real = new File(FileUtility.getWorkingCopyPath(local.getResource()));
            if (real.exists() && !real.renameTo(change.getTemporary())) {
                FileUtility.copyFile(change.getTemporary(), real, monitor);
                real.delete();
            }
        }
    }

    @Override
    public void postVisit(ResourceChange change, IActionOperationProcessor processor, IProgressMonitor monitor) throws Exception {
    }
}

