/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;

public class RevertOperation
extends AbstractWorkingCopyOperation {
    protected boolean doRecursiveRevert;

    public RevertOperation(IResource[] resources, boolean doRecursiveRevert) {
        super("Operation_Revert", SVNMessages.class, resources);
        this.doRecursiveRevert = doRecursiveRevert;
    }

    public RevertOperation(IResourceProvider provider, boolean doRecursiveRevert) {
        super("Operation_Revert", SVNMessages.class, provider);
        this.doRecursiveRevert = doRecursiveRevert;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        if (this.doRecursiveRevert) {
            resources = FileUtility.shrinkChildNodesWithSwitched(resources);
        } else {
            FileUtility.reorder(resources, false);
        }
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            IRepositoryLocation location = storage.getRepositoryLocation(resources[i]);
            String wcPath = FileUtility.getWorkingCopyPath(resources[i]);
            ISVNConnector proxy = location.acquireSVNProxy();
            this.writeToConsole(0, "svn revert \"" + FileUtility.normalizePath(wcPath) + "\"" + (this.doRecursiveRevert ? " -R" : "") + "\n");
            this.protectStep(monitor1 -> proxy.revert(new String[]{wcPath}, SVNDepth.infinityOrEmpty(this.doRecursiveRevert), null, 0L, new SVNProgressMonitor(this, monitor1, null)), monitor, resources.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }
}

