/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file.property;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.file.AbstractFileOperation;
import org.eclipse.team.svn.core.operation.file.IFileProvider;
import org.eclipse.team.svn.core.operation.file.SVNFileStorage;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;

public class RemovePropertyOperation
extends AbstractFileOperation {
    protected boolean isRecursive;
    protected String[] names;

    public RemovePropertyOperation(File[] files, String[] names, boolean isRecursive) {
        super("Operation_RemovePropertiesFile", SVNMessages.class, files);
        this.names = names;
        this.isRecursive = isRecursive;
    }

    public RemovePropertyOperation(IFileProvider provider, String[] names, boolean isRecursive) {
        super("Operation_RemovePropertiesFile", SVNMessages.class, provider);
        this.names = names;
        this.isRecursive = isRecursive;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File[] files = this.operableData();
        if (this.isRecursive) {
            files = FileUtility.shrinkChildNodes(files, false);
        }
        int i = 0;
        while (i < files.length && !monitor.isCanceled()) {
            File current = files[i];
            IRepositoryResource remote = SVNFileStorage.instance().asRepositoryResource(files[i], false);
            IRepositoryLocation location = remote.getRepositoryLocation();
            ISVNConnector proxy = location.acquireSVNProxy();
            this.protectStep(monitor2 -> {
                int i1 = 0;
                while (i1 < this.names.length && !monitor2.isCanceled()) {
                    String name = this.names[i1];
                    this.protectStep(monitor1 -> proxy.setPropertyLocal(new String[]{current.getAbsolutePath()}, new SVNProperty(name), this.isRecursive ? SVNDepth.INFINITY : SVNDepth.EMPTY, 0L, null, new SVNProgressMonitor(this, monitor1, null)), monitor2, this.names.length);
                    ++i1;
                }
            }, monitor, files.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }

    @Override
    protected ISchedulingRule getSchedulingRule(File file) {
        return file.isDirectory() ? new AbstractFileOperation.LockingRule(file) : super.getSchedulingRule(file);
    }
}

