/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNConflictResolution;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.file.AbstractFileOperation;
import org.eclipse.team.svn.core.operation.file.IFileProvider;
import org.eclipse.team.svn.core.operation.file.SVNFileStorage;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.utility.FileUtility;

public class MarkResolvedOperation
extends AbstractFileOperation {
    protected boolean recursive;

    public MarkResolvedOperation(File[] files, boolean recursive) {
        super("Operation_MarkResolvedFile", SVNMessages.class, files);
        this.recursive = recursive;
    }

    public MarkResolvedOperation(IFileProvider provider, boolean recursive) {
        super("Operation_MarkResolvedFile", SVNMessages.class, provider);
        this.recursive = recursive;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File[] files = this.operableData();
        if (this.recursive) {
            files = FileUtility.shrinkChildNodes(files, false);
        } else {
            FileUtility.reorder(files, true);
        }
        int i = 0;
        while (i < files.length && !monitor.isCanceled()) {
            File current = files[i];
            IRepositoryLocation location = SVNFileStorage.instance().asRepositoryResource(current, false).getRepositoryLocation();
            ISVNConnector proxy = location.acquireSVNProxy();
            this.protectStep(monitor1 -> proxy.resolve(current.getAbsolutePath(), SVNConflictResolution.Choice.CHOOSE_MERGED, SVNDepth.infinityOrEmpty(this.recursive), new SVNProgressMonitor(this, monitor1, null)), monitor, files.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }
}

