/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.discovery.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.spi.IDynamicExtensionRegistry;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.core.runtime.spi.RegistryStrategy;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.osgi.framework.Bundle;

class DiscoveryRegistryStrategy
extends RegistryStrategy {
    private final List<JarFile> jars = new ArrayList<JarFile>();
    private final Map<IContributor, File> contributorToJarFile = new HashMap<IContributor, File>();
    private final Map<IContributor, String> contributorToDirectoryEntry = new HashMap<IContributor, String>();
    private final Object token;
    private File bundleFile;
    private String discoveryUrl;

    public DiscoveryRegistryStrategy(File[] storageDirs, boolean[] cacheReadOnly, Object token) {
        super(storageDirs, cacheReadOnly);
        this.token = token;
    }

    public void onStart(IExtensionRegistry registry, boolean loadedFromCache) {
        super.onStart(registry, loadedFromCache);
        if (!loadedFromCache) {
            this.processDiscoveryCoreBundle(registry);
            this.processBundles(registry);
        }
    }

    private void processDiscoveryCoreBundle(IExtensionRegistry registry) {
        try {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.team.svn.core");
            RegistryContributor contributor = new RegistryContributor(bundle.getSymbolicName(), bundle.getSymbolicName(), null, null);
            InputStream inputStream = bundle.getEntry("plugin.xml").openStream();
            Throwable throwable = null;
            Object var6_7 = null;
            try {
                try {
                    registry.addContribution(inputStream, (IContributor)contributor, false, bundle.getSymbolicName(), null, this.token);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
    }

    private void processBundles(IExtensionRegistry registry) {
        if (this.bundleFile == null || this.discoveryUrl == null) {
            throw new IllegalStateException();
        }
        try {
            this.processBundle(registry);
        }
        catch (Exception e) {
            String errMessage = BaseMessages.format(SVNMessages.DiscoveryRegistryStrategy_cannot_load_bundle, new Object[]{this.bundleFile.getName(), this.discoveryUrl, e.getMessage()});
            LoggedOperation.reportError(((Object)((Object)this)).getClass().getName(), new Exception(errMessage, e));
        }
    }

    private void processBundle(IExtensionRegistry registry) throws IOException {
        JarFile jarFile = new JarFile(this.bundleFile);
        this.jars.add(jarFile);
        ZipEntry pluginXmlEntry = jarFile.getEntry("plugin.xml");
        if (pluginXmlEntry == null) {
            throw new IOException(SVNMessages.DiscoveryRegistryStrategy_missing_pluginxml);
        }
        RegistryContributor contributor = new RegistryContributor(this.bundleFile.getName(), this.bundleFile.getName(), null, null);
        if (((IDynamicExtensionRegistry)registry).hasContributor((IContributor)contributor)) {
            jarFile.close();
            return;
        }
        this.contributorToJarFile.put((IContributor)contributor, this.bundleFile);
        this.contributorToDirectoryEntry.put((IContributor)contributor, this.discoveryUrl);
        ResourceBundle translationBundle = this.loadTranslationBundle(jarFile);
        InputStream inputStream = jarFile.getInputStream(pluginXmlEntry);
        Throwable throwable = null;
        Object var8_9 = null;
        try {
            try {
                registry.addContribution(inputStream, (IContributor)contributor, false, this.bundleFile.getPath(), translationBundle, this.token);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private ResourceBundle loadTranslationBundle(JarFile jarFile) throws IOException {
        List<String> bundleNames = this.computeBundleNames("plugin");
        for (String bundleName : bundleNames) {
            ZipEntry entry = jarFile.getEntry(bundleName);
            if (entry == null) continue;
            InputStream inputStream = jarFile.getInputStream(entry);
            Throwable throwable = null;
            Object var8_9 = null;
            try {
                try {
                    PropertyResourceBundle resourceBundle = new PropertyResourceBundle(inputStream);
                    return resourceBundle;
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return null;
    }

    private List<String> computeBundleNames(String baseName) {
        String suffix = ".properties";
        Object name = baseName;
        ArrayList<String> bundleNames = new ArrayList<String>();
        Locale locale = Locale.getDefault();
        bundleNames.add((String)name + suffix);
        if (locale.getLanguage() != null && locale.getLanguage().length() > 0) {
            name = (String)name + "_" + locale.getLanguage();
            bundleNames.add(0, (String)name + suffix);
        }
        if (locale.getCountry() != null && locale.getCountry().length() > 0) {
            name = (String)name + "_" + locale.getCountry();
            bundleNames.add(0, (String)name + suffix);
        }
        if (locale.getVariant() != null && locale.getVariant().length() > 0) {
            name = (String)name + "_" + locale.getVariant();
            bundleNames.add(0, (String)name + suffix);
        }
        return bundleNames;
    }

    /*
     * Unable to fully structure code
     */
    public void onStop(IExtensionRegistry registry) {
        try {
            super.onStop(registry);
        }
        finally {
            ** for (jar : this.jars)
        }
lbl-1000:
        // 1 sources

        {
            try {
                jar.close();
            }
            catch (Exception v0) {}
            continue;
        }
lbl11:
        // 1 sources

        this.jars.clear();
    }

    public File getJarFile(IContributor contributor) {
        File file = this.contributorToJarFile.get(contributor);
        if (file == null) {
            throw new IllegalArgumentException(contributor.getName());
        }
        return file;
    }

    public void setDiscoveryInfo(File bundleFile, String discoveryUrl) {
        this.bundleFile = bundleFile;
        this.discoveryUrl = discoveryUrl;
    }
}

