/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.connector;

import org.eclipse.team.svn.core.connector.SVNLock;

public class SVNEntry {
    public final String path;
    public final long revision;
    public final long date;
    public final String author;
    public final boolean hasProperties;
    public final Kind nodeKind;
    public final long size;
    public final SVNLock lock;

    public SVNEntry(String path, long revision, long date, String author, boolean hasProperties, Kind nodeKind, long size, SVNLock lock) {
        this.date = date;
        this.revision = revision;
        this.hasProperties = hasProperties;
        this.author = author;
        this.nodeKind = nodeKind;
        this.size = size;
        this.path = path;
        this.lock = lock;
    }

    public String toString() {
        return this.path;
    }

    public static class Fields {
        public static final int NONE = 0;
        public static final int ALL = -1;
        public static final int AUTHOR = 32;
        public static final int DATE = 16;
        public static final int REVISION = 8;
        public static final int HAS_PROPERTIES = 4;
        public static final int SIZE = 2;
        public static final int NODE_KIND = 1;
    }

    public static enum Kind {
        NONE(0),
        FILE(1),
        DIR(2),
        UNKNOWN(3),
        SYMLINK(4);

        public final int id;

        public static Kind fromId(int id) {
            Kind[] kindArray = Kind.values();
            int n = kindArray.length;
            int n2 = 0;
            while (n2 < n) {
                Kind kind = kindArray[n2];
                if (kind.id == id) {
                    return kind;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Invalid entry kind: " + id);
        }

        private Kind(int id) {
            this.id = id;
        }
    }
}

