/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.svn.core.IProjectSetHandler;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.remote.CheckoutAsOperation;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class SubclipseProjectSetHandler
implements IProjectSetHandler {
    protected static final String PLUGIN_INFORMATION = "0.9.3";

    @Override
    public String getProjectNameForReference(String fullReference) {
        String[] parts = fullReference.split(",");
        if (parts.length < 3 || !parts[0].equals(PLUGIN_INFORMATION)) {
            return null;
        }
        return parts[2];
    }

    @Override
    public IProject configureCheckoutOperation(CompositeOperation op, IProject project, String fullReference) throws TeamException {
        String[] parts = fullReference.split(",");
        IRepositoryLocation location = this.getLocationForReference(parts);
        IRepositoryContainer resource = location.asRepositoryContainer(parts[1], true);
        if (resource != null) {
            String projectLocation = project.exists() ? FileUtility.getResourcePath((IResource)project).removeLastSegments(1).toString() : Platform.getLocation().toString();
            CheckoutAsOperation mainOp = new CheckoutAsOperation(project.getName(), (IRepositoryResource)resource, projectLocation, SVNDepth.INFINITY, false);
            op.add(mainOp);
            return mainOp.getProject();
        }
        return null;
    }

    protected IRepositoryLocation getLocationForReference(String[] parts) {
        IRepositoryLocation location = null;
        String url = parts[1];
        IRepositoryLocation[] locations = SVNRemoteStorage.instance().getRepositoryLocations();
        IPath awaitingFor = SVNUtility.createPathForSVNUrl(url);
        IRepositoryLocation[] iRepositoryLocationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryLocation location2 = iRepositoryLocationArray[n2];
            if (SVNUtility.createPathForSVNUrl(location2.getUrl()).isPrefixOf(awaitingFor)) {
                return location2;
            }
            ++n2;
        }
        if (location == null) {
            location = SVNRemoteStorage.instance().newRepositoryLocation();
            location.setUrl(url);
        }
        SVNRemoteStorage.instance().addRepositoryLocation(location);
        return location;
    }

    @Override
    public String asReference(IProject project) throws TeamException {
        throw new RuntimeException("Unsupported operation");
    }

    @Override
    public String asReference(String resourceUrl, String projectName) {
        throw new RuntimeException("Unsupported operation");
    }

    @Override
    public boolean accept(String referenceString) {
        return referenceString.startsWith(PLUGIN_INFORMATION);
    }
}

