/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.operation;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.remote.GetLogMessagesOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class CorrectRevisionOperation
extends AbstractActionOperation {
    protected IRepositoryResource[] repositoryResources;
    protected long[] knownRevisions;
    protected GetLogMessagesOperation[] msgsOps;
    protected IResource[] resources;
    protected boolean hasWarning;
    protected boolean isCancel;

    public CorrectRevisionOperation(GetLogMessagesOperation msgsOp, IRepositoryResource repositoryResource, long knownRevision, IResource resource) {
        GetLogMessagesOperation[] getLogMessagesOperationArray;
        if (msgsOp == null) {
            getLogMessagesOperationArray = null;
        } else {
            GetLogMessagesOperation[] getLogMessagesOperationArray2 = new GetLogMessagesOperation[1];
            getLogMessagesOperationArray = getLogMessagesOperationArray2;
            getLogMessagesOperationArray2[0] = msgsOp;
        }
        this(getLogMessagesOperationArray, new IRepositoryResource[]{repositoryResource}, new long[]{knownRevision}, new IResource[]{resource});
    }

    public CorrectRevisionOperation(GetLogMessagesOperation[] msgsOps, IRepositoryResource[] repositoryResources, long[] knownRevisions, IResource[] resources) {
        super("Operation_CorrectRevision", SVNUIMessages.class);
        this.repositoryResources = repositoryResources;
        this.knownRevisions = knownRevisions;
        this.msgsOps = msgsOps;
        this.resources = resources;
    }

    public int getOperationWeight() {
        if (this.msgsOps == null) {
            return 0;
        }
        return super.getOperationWeight();
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        int i = 0;
        while (i < this.repositoryResources.length) {
            if (!this.repositoryResources[i].exists() && this.resources != null && this.resources[i] != null && this.resources[i].getType() != 4) {
                boolean switchedStateEquals;
                ILocalResource parent = SVNRemoteStorage.instance().asLocalResourceAccessible((IResource)this.resources[i].getParent());
                ILocalResource self = SVNRemoteStorage.instance().asLocalResourceAccessible(this.resources[i]);
                boolean bl = switchedStateEquals = (parent.getChangeMask() & 8) == (self.getChangeMask() & 8);
                if (switchedStateEquals) {
                    long selfRevision;
                    long revision;
                    long parentRevision = parent.getRevision();
                    long l = revision = parentRevision > (selfRevision = self.getRevision()) ? parentRevision : selfRevision;
                    if (revision != -1L) {
                        this.repositoryResources[i].setPegRevision((SVNRevision)SVNRevision.fromNumber((long)revision));
                    }
                } else {
                    this.repositoryResources[i].setPegRevision((SVNRevision)SVNRevision.fromNumber((long)self.getRevision()));
                }
            }
            if (!this.repositoryResources[i].exists() && this.knownRevisions[i] != -1L) {
                this.hasWarning = true;
                SVNRevision.Number rev = SVNRevision.fromNumber((long)this.knownRevisions[i]);
                this.repositoryResources[i].setSelectedRevision((SVNRevision)rev);
                this.repositoryResources[i].setPegRevision((SVNRevision)rev);
                if (this.msgsOps != null) {
                    this.msgsOps[i].setStartRevision((SVNRevision)rev);
                }
            }
            ++i;
        }
        if (this.hasWarning) {
            UIMonitorUtility.getDisplay().syncExec(() -> {
                boolean one = this.repositoryResources.length == 1;
                MessageDialog dlg = new MessageDialog(UIMonitorUtility.getShell(), this.getOperationResource(one ? "Title_Single" : "Title_Multi"), null, this.getOperationResource(one ? "Message_Single" : "Message_Multi"), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                if (dlg.open() != 0) {
                    monitor.setCanceled(true);
                    this.isCancel = true;
                }
            });
        }
    }

    public boolean hasWarning() {
        return this.hasWarning;
    }

    public boolean isCancel() {
        return this.isCancel;
    }
}

