/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.io.File;
import java.io.FileOutputStream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.AbstractGetFileContentOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;

public class GetLocalFileContentOperation
extends AbstractGetFileContentOperation {
    protected IResource resource;
    protected SVNRevision revision;

    public GetLocalFileContentOperation(IResource resource, SVNRevision.Kind revisionKind) {
        super("Local");
        this.resource = resource;
        this.revision = revisionKind == SVNRevision.Kind.BASE ? SVNRevision.BASE : SVNRevision.WORKING;
    }

    @Override
    public int getOperationWeight() {
        return 0;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        if (this.revision.getKind() == SVNRevision.Kind.BASE) {
            IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(this.resource);
            ISVNConnector proxy = location.acquireSVNProxy();
            FileOutputStream stream = null;
            try {
                this.tmpFile = this.createTempFile();
                stream = new FileOutputStream(this.tmpFile);
                proxy.streamFileContent(new SVNEntryRevisionReference(FileUtility.getWorkingCopyPath(this.resource), null, this.revision), 2048L, stream, new SVNProgressMonitor(this, monitor, null));
            }
            catch (Throwable throwable) {
                location.releaseSVNProxy(proxy);
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            location.releaseSVNProxy(proxy);
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        } else {
            this.tmpFile = new File(FileUtility.getWorkingCopyPath(this.resource));
        }
    }

    @Override
    protected String getExtension() {
        return this.resource.getFileExtension();
    }

    @Override
    protected String getShortErrorMessage(Throwable t) {
        return BaseMessages.format(super.getShortErrorMessage(t), new Object[]{this.resource.getName()});
    }
}

