/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.SVNResourceRuleFactory;
import org.eclipse.team.svn.core.resource.IResourceProvider;

public abstract class AbstractWorkingCopyOperation
extends AbstractActionOperation {
    private IResource[] resources;
    private IResourceProvider provider;

    public AbstractWorkingCopyOperation(String operationName, Class<? extends NLS> messagesClass, IResource[] resources) {
        super(operationName, messagesClass);
        this.resources = resources;
    }

    public AbstractWorkingCopyOperation(String operationName, Class<? extends NLS> messagesClass, IResourceProvider provider) {
        super(operationName, messagesClass);
        this.provider = provider;
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        if (this.resources == null || this.resources.length == 0) {
            return ResourcesPlugin.getWorkspace().getRoot();
        }
        HashSet<ISchedulingRule> ruleSet = new HashSet<ISchedulingRule>();
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            ruleSet.add(SVNResourceRuleFactory.INSTANCE.refreshRule(element));
            ++n2;
        }
        return new MultiRule(ruleSet.toArray(new ISchedulingRule[ruleSet.size()]));
    }

    protected IResource[] operableData() {
        return this.resources == null ? this.provider.getResources() : this.resources;
    }
}

