/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.update;

import java.util.Collection;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSubscriber;
import org.eclipse.team.svn.core.synchronize.UpdateSubscriber;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.extension.ExtensionsManager;
import org.eclipse.team.svn.ui.synchronize.AbstractSVNParticipant;
import org.eclipse.team.svn.ui.synchronize.AbstractSynchronizeActionGroup;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.ResourceScope;

public class UpdateParticipant
extends AbstractSVNParticipant {
    public static final String PARTICIPANT_ID = "org.eclipse.team.svn.ui.synchronize.update.SynchronizeParticipant";

    public UpdateParticipant() {
    }

    public UpdateParticipant(ISynchronizeScope scope) {
        super(scope);
    }

    @Override
    public AbstractSVNSubscriber getMatchingSubscriber() {
        return UpdateSubscriber.instance();
    }

    public String getName() {
        String name = SVNUIMessages.SynchronizeParticipant;
        ISynchronizeScope scope = this.getScope();
        String scopeName = scope.getName();
        if (scope instanceof ResourceScope) {
            StringBuilder buffer = new StringBuilder();
            IResource[] resources = scope.getRoots();
            int i = 0;
            while (i < resources.length) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(resources[i].getFullPath().toString().substring(1));
                ++i;
            }
            scopeName = buffer.toString();
        }
        return BaseMessages.format((String)TeamUIMessages.SubscriberParticipant_namePattern, (Object[])new String[]{name, scopeName});
    }

    @Override
    protected String getParticipantId() {
        return PARTICIPANT_ID;
    }

    @Override
    protected Collection<AbstractSynchronizeActionGroup> getActionGroups() {
        return ExtensionsManager.getInstance().getCurrentSynchronizeActionContributor().getUpdateContributions();
    }

    @Override
    protected int getSupportedModes() {
        return 15;
    }

    @Override
    protected int getDefaultMode() {
        return 4;
    }
}

