/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.verifier;

import org.eclipse.swt.widgets.Control;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.verifier.AbstractFormattedVerifier;

public class ProxyPortVerifier
extends AbstractFormattedVerifier {
    protected static String ERROR_RANGE;
    protected static String ERROR_NAN;

    public ProxyPortVerifier(String fieldName) {
        super(fieldName);
        ERROR_RANGE = BaseMessages.format((String)SVNUIMessages.Verifier_ProxyPort_Range, (Object[])new String[]{"$FIELD_NAME$"});
        ERROR_NAN = BaseMessages.format((String)SVNUIMessages.Verifier_ProxyPort_NaN, (Object[])new String[]{"$FIELD_NAME$"});
    }

    @Override
    protected String getErrorMessageImpl(Control hostField) {
        String portString = this.getText(hostField);
        if (portString.trim().length() == 0) {
            return null;
        }
        try {
            int port = Integer.parseInt(portString);
            if (port < 0 || port > 65535) {
                return ERROR_RANGE;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return ERROR_NAN;
        }
        return null;
    }

    @Override
    protected String getWarningMessageImpl(Control input) {
        return null;
    }
}

