/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.utility;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.local.ResourceListPanel;

public class UnacceptableOperationNotificator {
    public static IResource[] shrinkResourcesWithNotOnRespositoryParents(Shell shell, IResource[] resources) {
        HashSet<Object> resultResources = new HashSet<Object>();
        HashMap<IResource, IResource[]> unsupportedResources = new HashMap<IResource, IResource[]>();
        if (resources == null) {
            return null;
        }
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            IResource[] parents = FileUtility.getOperableParents((IResource[])new IResource[]{element}, (IStateFilter)IStateFilter.SF_NOTONREPOSITORY, (boolean)true);
            ILocalResource local = SVNRemoteStorage.instance().asLocalResourceAccessible(element);
            if (parents.length > 0 && IStateFilter.SF_ONREPOSITORY.accept(local)) {
                unsupportedResources.put(element, parents);
            } else {
                resultResources.add(element);
            }
            ++n2;
        }
        if (!resultResources.isEmpty() && !unsupportedResources.isEmpty()) {
            Iterator iter = unsupportedResources.keySet().iterator();
            while (iter.hasNext()) {
                IResource res = (IResource)iter.next();
                List<IResource> listOfParents = Arrays.asList((IResource[])unsupportedResources.get(res));
                if (!resultResources.containsAll(listOfParents)) continue;
                iter.remove();
            }
        }
        boolean[] isCanceled = new boolean[1];
        if (!unsupportedResources.isEmpty()) {
            HashSet<IResource> parents = new HashSet<IResource>();
            for (IResource res : unsupportedResources.keySet()) {
                parents.addAll(Arrays.asList((IResource[])unsupportedResources.get(res)));
            }
            shell.getDisplay().syncExec(() -> {
                String defaultMessage;
                String description;
                boolean oneResource;
                boolean oneParent = parents.size() == 1;
                boolean bl = oneResource = unsupportedResources.size() == 1;
                if (oneParent && oneResource) {
                    description = SVNUIMessages.UnacceptableOperation_Description_1;
                    defaultMessage = SVNUIMessages.UnacceptableOperation_Message_1;
                } else if (!oneParent && oneResource) {
                    description = SVNUIMessages.UnacceptableOperation_Description_2;
                    defaultMessage = SVNUIMessages.UnacceptableOperation_Message_2;
                } else if (oneParent && !oneResource) {
                    description = SVNUIMessages.UnacceptableOperation_Description_3;
                    defaultMessage = SVNUIMessages.UnacceptableOperation_Message_3;
                } else {
                    description = SVNUIMessages.UnacceptableOperation_Description_4;
                    defaultMessage = SVNUIMessages.UnacceptableOperation_Message_4;
                }
                ResourceListPanel panel = new ResourceListPanel(unsupportedResources.keySet().toArray(new IResource[unsupportedResources.size()]), SVNUIMessages.UnacceptableOperation_Title, description, defaultMessage, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL});
                DefaultDialog dialog = new DefaultDialog(shell, panel);
                if (dialog.open() != 0) {
                    blArray[0] = true;
                }
            });
            if (isCanceled[0]) {
                return null;
            }
            resultResources.addAll(parents);
        }
        return resultResources.toArray(new IResource[resultResources.size()]);
    }
}

