/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.operation;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNDiffStatus;
import org.eclipse.team.svn.core.connector.SVNEntry;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNEntryStatus;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.resource.ILocalFolder;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.compare.ComparePanel;
import org.eclipse.team.svn.ui.compare.ResourceCompareInput;
import org.eclipse.team.svn.ui.compare.ThreeWayResourceCompareInput;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class CompareResourcesInternalOperation
extends AbstractActionOperation {
    protected ILocalResource local;
    protected IRepositoryResource ancestor;
    protected IRepositoryResource remote;
    protected boolean showInDialog;
    protected boolean forceReuse;
    protected String forceId;
    protected long options;

    public CompareResourcesInternalOperation(ILocalResource local, IRepositoryResource remote, boolean forceReuse, boolean showInDialog, long options) {
        super("Operation_CompareLocal", SVNUIMessages.class);
        this.local = local;
        this.ancestor = local.isCopied() ? SVNUtility.getCopiedFrom((ILocalResource)local) : SVNRemoteStorage.instance().asRepositoryResource(local.getResource());
        this.ancestor.setSelectedRevision((SVNRevision)(local.getBaseRevision() != -1L ? SVNRevision.fromNumber((long)local.getBaseRevision()) : SVNRevision.INVALID_REVISION));
        this.remote = remote;
        this.showInDialog = showInDialog;
        this.forceReuse = forceReuse;
        this.options = options;
    }

    public void setForceId(String forceId) {
        this.forceId = forceId;
    }

    public String getForceId() {
        return this.forceId;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        ArrayList<SVNDiffStatus> localChanges = new ArrayList<SVNDiffStatus>();
        ArrayList<SVNDiffStatus> remoteChanges = new ArrayList<SVNDiffStatus>();
        IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(this.local.getResource());
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            if (CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() == 7 || this.remote.getSelectedRevision() == SVNRevision.BASE) {
                this.fetchStatuses17(proxy, localChanges, remoteChanges, monitor);
            } else {
                this.fetchStatuses18(proxy, localChanges, remoteChanges, monitor);
            }
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
        this.protectStep(monitor1 -> {
            CompareConfiguration cc = new CompareConfiguration();
            cc.setProperty("org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY", (Object)Boolean.TRUE);
            ThreeWayResourceCompareInput compare = new ThreeWayResourceCompareInput(cc, this.local, this.ancestor, this.remote, localChanges, remoteChanges);
            compare.setForceId(this.forceId);
            compare.initialize(monitor1);
            if (!monitor1.isCanceled()) {
                UIMonitorUtility.getDisplay().syncExec(() -> {
                    if (this.showInDialog) {
                        if (this.compareResultOK((CompareEditorInput)compare)) {
                            ComparePanel panel = new ComparePanel((CompareEditorInput)compare, this.local.getResource());
                            DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getShell(), panel);
                            dialog.open();
                        }
                    } else {
                        ResourceCompareInput.openCompareEditor(compare, this.forceReuse);
                    }
                });
            }
        }, monitor, 100, 50);
    }

    protected void fetchStatuses17(ISVNConnector proxy, ArrayList<SVNDiffStatus> localChanges, ArrayList<SVNDiffStatus> remoteChanges, IProgressMonitor monitor) throws Exception {
        HashMap resourcesWithChanges = new HashMap();
        IContainer compareRoot = this.local instanceof ILocalFolder ? (IContainer)this.local.getResource() : this.local.getResource().getParent();
        IRepositoryResource resource = SVNRemoteStorage.instance().asRepositoryResource(this.local.getResource());
        long cmpTargetRevision = this.remote.getSelectedRevision().getKind() == SVNRevision.Kind.BASE ? this.local.getRevision() : (resource.exists() ? resource.getRevision() : -1L);
        LinkedHashSet<Long> revisions = new LinkedHashSet<Long>();
        if (cmpTargetRevision != -1L) {
            revisions.add(cmpTargetRevision);
            this.protectStep(monitor1 -> {
                String rootPath = FileUtility.getWorkingCopyPath((IResource)this.local.getResource());
                long options = 0x200000001L;
                if (this.remote.getSelectedRevision() != SVNRevision.BASE) {
                    options |= 0x40L;
                }
                proxy.status(rootPath, SVNDepth.INFINITY, options, null, status -> {
                    String textStatus;
                    Path tPath = new Path(status.path.substring(rootPath.length()));
                    IResource resource1 = compareRoot.findMember((IPath)tPath);
                    if (resource1 == null) {
                        Object object = resource1 = status.nodeKind == SVNEntry.Kind.FILE ? compareRoot.getFile((IPath)tPath) : compareRoot.getFolder((IPath)tPath);
                    }
                    if (IStateFilter.SF_ANY_CHANGE.accept(resource1, textStatus = SVNRemoteStorage.getTextStatusString((SVNEntryStatus.Kind)status.propStatus, (SVNEntryStatus.Kind)status.textStatus, (boolean)false), 0) || status.propStatus == SVNEntryStatus.Kind.MODIFIED) {
                        localChanges.add(new SVNDiffStatus(status.path, status.path, status.nodeKind, status.textStatus, status.propStatus));
                    }
                    if ((IStateFilter.SF_ANY_CHANGE.accept(resource1, textStatus = SVNRemoteStorage.getTextStatusString((SVNEntryStatus.Kind)status.repositoryPropStatus, (SVNEntryStatus.Kind)status.repositoryTextStatus, (boolean)true), 0) || status.repositoryTextStatus == SVNEntryStatus.Kind.MODIFIED) && status.revision != cmpTargetRevision) {
                        resourcesWithChanges.put(resource1, status.revision);
                        revisions.add(status.revision);
                    }
                }, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)this, monitor1, null, false));
            }, monitor, 100, 10);
        } else {
            String path = FileUtility.getWorkingCopyPath((IResource)this.local.getResource());
            localChanges.add(new SVNDiffStatus(path, path, this.local.getResource().getType() == 1 ? SVNEntry.Kind.FILE : SVNEntry.Kind.DIR, SVNEntryStatus.Kind.UNVERSIONED, SVNEntryStatus.Kind.NORMAL));
        }
        if (this.remote.getSelectedRevision() != SVNRevision.BASE) {
            Iterator iterator = revisions.iterator();
            while (iterator.hasNext()) {
                long revision = (Long)iterator.next();
                this.protectStep(monitor1 -> {
                    IRepositoryResource resource2 = SVNRemoteStorage.instance().asRepositoryResource(this.local.getResource());
                    resource2.setSelectedRevision((SVNRevision)SVNRevision.fromNumber((long)revision));
                    SVNEntryRevisionReference refPrev = SVNUtility.getEntryRevisionReference((IRepositoryResource)resource2);
                    SVNEntryRevisionReference refNext = SVNUtility.getEntryRevisionReference((IRepositoryResource)this.remote);
                    String prevRootURL = resource2.getUrl();
                    proxy.diffStatusTwo(refPrev, refNext, SVNDepth.INFINITY, this.options, null, status -> {
                        Long rev;
                        Path tPath = new Path(status.pathPrev.substring(prevRootURL.length()));
                        IResource resource1 = compareRoot.findMember((IPath)tPath);
                        if (resource1 == null) {
                            Object object = resource1 = status.nodeKind == SVNEntry.Kind.FILE ? compareRoot.getFile((IPath)tPath) : compareRoot.getFolder((IPath)tPath);
                        }
                        if ((rev = (Long)resourcesWithChanges.get(resource1)) == null || rev == revision) {
                            String pathPrev = this.ancestor.getUrl() + status.pathNext.substring(sVNEntryRevisionReference.path.length());
                            remoteChanges.add(new SVNDiffStatus(pathPrev, status.pathNext, status.nodeKind, status.textStatus, status.propStatus));
                        }
                    }, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)this, monitor1, null, false));
                }, monitor, 100, 40 / revisions.size());
            }
        }
    }

    protected void fetchStatuses18(ISVNConnector proxy, ArrayList<SVNDiffStatus> localChanges, ArrayList<SVNDiffStatus> remoteChanges, IProgressMonitor monitor) {
        IContainer compareRoot = this.local instanceof ILocalFolder ? (IContainer)this.local.getResource() : this.local.getResource().getParent();
        this.protectStep(monitor1 -> {
            String rootPath = FileUtility.getWorkingCopyPath((IResource)this.local.getResource());
            String searchPath = this.local.getResource().getType() == 1 ? FileUtility.getWorkingCopyPath((IResource)this.local.getResource().getParent()) : rootPath;
            long options = 0x200000001L;
            if (this.remote.getSelectedRevision() != SVNRevision.BASE) {
                options |= 0x40L;
            }
            proxy.status(rootPath, SVNDepth.INFINITY, options, null, status -> {
                String textStatus;
                Path tPath = new Path(status.path.substring(searchPath.length()));
                IResource resource = compareRoot.findMember((IPath)tPath);
                if (resource == null) {
                    Object object = resource = status.nodeKind == SVNEntry.Kind.FILE ? compareRoot.getFile((IPath)tPath) : compareRoot.getFolder((IPath)tPath);
                }
                if (IStateFilter.SF_ANY_CHANGE.accept(resource, textStatus = SVNRemoteStorage.getTextStatusString((SVNEntryStatus.Kind)status.propStatus, (SVNEntryStatus.Kind)status.textStatus, (boolean)false), 0) || status.propStatus == SVNEntryStatus.Kind.MODIFIED) {
                    localChanges.add(new SVNDiffStatus(status.path, status.path, status.nodeKind, status.textStatus, status.propStatus));
                }
            }, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)this, monitor1, null, false));
        }, monitor, 100, 10);
        this.protectStep(monitor1 -> {
            IPath rootPath = FileUtility.getResourcePath((IResource)compareRoot);
            boolean isFile = this.local.getResource().getType() == 1;
            SVNEntryRevisionReference refPrev = new SVNEntryRevisionReference(FileUtility.getWorkingCopyPath((IResource)this.local.getResource()), null, SVNRevision.WORKING);
            SVNEntryRevisionReference refNext = SVNUtility.getEntryRevisionReference((IRepositoryResource)this.remote);
            FakeOutputStream diffPathCollector = new FakeOutputStream();
            proxy.diffTwo(refPrev, refNext, rootPath.toFile().getAbsolutePath(), (OutputStream)diffPathCollector, SVNDepth.INFINITY, this.options, null, 0L, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)this, monitor1, null, false));
            proxy.diffStatusTwo(refPrev, refNext, SVNDepth.INFINITY, this.options, null, status -> {
                ILocalResource local;
                Path tPath = new Path(status.pathPrev);
                IResource resource = compareRoot.findMember((IPath)(tPath = tPath.removeFirstSegments(rootPath.segmentCount())));
                if (resource == null) {
                    Object object = resource = status.nodeKind == SVNEntry.Kind.FILE ? compareRoot.getFile((IPath)tPath) : compareRoot.getFolder((IPath)tPath);
                }
                if (!IStateFilter.SF_ANY_CHANGE.accept(local = SVNRemoteStorage.instance().asLocalResource(resource)) || IStateFilter.SF_NOTEXISTS.accept(local)) {
                    String diffPathEntry;
                    SVNEntryStatus.Kind change = status.textStatus == SVNEntryStatus.Kind.ADDED ? SVNEntryStatus.Kind.DELETED : (status.textStatus == SVNEntryStatus.Kind.DELETED ? SVNEntryStatus.Kind.ADDED : status.textStatus);
                    String string = diffPathEntry = status.pathNext.startsWith(sVNEntryRevisionReference.path) && !status.pathNext.equals(sVNEntryRevisionReference.path) ? status.pathNext.substring(sVNEntryRevisionReference.path.length()) : "/" + resource.getName();
                    if (status.nodeKind == SVNEntry.Kind.DIR || diffPathCollector.contains(diffPathEntry)) {
                        Object relativePart = isFile ? "" : diffPathEntry;
                        String pathPrev = this.ancestor.getUrl() + (String)relativePart;
                        remoteChanges.add(new SVNDiffStatus(pathPrev, status.pathNext, status.nodeKind, change, status.propStatus));
                    }
                }
            }, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)this, monitor1, null, false));
        }, monitor, 100, 40);
    }

    protected boolean compareResultOK(CompareEditorInput input) {
        block5: {
            Shell shell = UIMonitorUtility.getShell();
            try {
                SVNTeamUIPlugin.instance().getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)input);
                String message = input.getMessage();
                if (message != null) {
                    MessageDialog.openError((Shell)shell, (String)Utilities.getString((String)"CompareUIPlugin.compareFailed"), (String)message);
                    break block5;
                }
                if (input.getCompareResult() == null) {
                    MessageDialog.openInformation((Shell)shell, (String)Utilities.getString((String)"CompareUIPlugin.dialogTitle"), (String)Utilities.getString((String)"CompareUIPlugin.noDifferences"));
                    break block5;
                }
                return true;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException x) {
                MessageDialog.openError((Shell)shell, (String)Utilities.getString((String)"CompareUIPlugin.compareFailed"), (String)x.getTargetException().getMessage());
            }
        }
        return false;
    }

    private static class FakeOutputStream
    extends OutputStream {
        boolean lineStart = true;
        boolean indexLine = false;
        Set<String> paths = new LinkedHashSet<String>();
        StringBuilder w = new StringBuilder();

        private FakeOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            char c = (char)b;
            if (c == 'I' && this.lineStart) {
                this.indexLine = true;
                this.w.append(c);
            } else if (c == '\n' || c == '\r') {
                if (this.indexLine) {
                    this.paths.add("/" + this.w.toString().substring("Index: ".length()));
                    this.w.replace(0, this.w.length(), "");
                }
                this.lineStart = true;
                this.indexLine = false;
            } else {
                this.lineStart = false;
                if (this.indexLine) {
                    this.w.append(c);
                }
            }
        }

        private Set<String> getPaths() {
            return this.paths;
        }

        public boolean contains(String path) {
            return this.getPaths().contains(path);
        }
    }
}

