/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.composite;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.resource.IRepositoryBase;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.RepositoryResourceSelectionComposite;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.common.RepositoryTreePanel;
import org.eclipse.team.svn.ui.verifier.IValidationManager;

public class DepthSelectionComposite
extends Composite {
    protected static final String empty = SVNUIMessages.RecurseDepthSelector_Empty;
    protected static final String files = SVNUIMessages.RecurseDepthSelector_Files;
    protected static final String immediates = SVNUIMessages.RecurseDepthSelector_Immediates;
    protected static final String infinity = SVNUIMessages.RecurseDepthSelector_Infinity;
    protected static final String exclude = SVNUIMessages.RecurseDepthSelector_Exclude;
    protected static final String unknown = SVNUIMessages.RecurseDepthSelector_Unknown;
    protected boolean useWorkingCopyDepth;
    protected boolean supportSetDepth;
    protected boolean isShowUpdateDepthPath;
    protected IRepositoryResource resource;
    protected IValidationManager validationManager;
    protected SVNDepth depth;
    protected boolean isStickyDepth;
    protected String updatePath;
    protected Combo depthSelector;
    protected Button updateDepthButton;
    protected Text pathInput;
    protected Button browseButton;
    protected RepositoryResourceSelectionComposite selectionComposite;
    protected boolean svn15compatible = CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() >= 5;
    protected boolean svn16compatible = CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() >= 6;

    public DepthSelectionComposite(Composite parent, int style, boolean useWorkingCopyDepth) {
        this(parent, style, useWorkingCopyDepth, false, false, null, null);
    }

    public DepthSelectionComposite(Composite parent, int style, boolean useWorkingCopyDepth, boolean supportSetDepth, boolean canShowUpdateDepthPath, IRepositoryResource resource, IValidationManager validationManager) {
        super(parent, style);
        this.supportSetDepth = supportSetDepth && this.svn15compatible;
        this.isStickyDepth = false;
        this.isShowUpdateDepthPath = this.supportSetDepth && canShowUpdateDepthPath;
        this.resource = resource;
        this.validationManager = validationManager;
        if (useWorkingCopyDepth && this.svn15compatible) {
            this.useWorkingCopyDepth = true;
            this.depth = this.isStickyDepth ? SVNDepth.INFINITY : SVNDepth.UNKNOWN;
        } else {
            this.useWorkingCopyDepth = false;
            this.depth = SVNDepth.INFINITY;
        }
        this.createControls();
    }

    protected void createControls() {
        DepthSelectionComposite parent;
        GridData data;
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        if (this.isShowUpdateDepthPath) {
            Group group = new Group((Composite)this, 0);
            layout = new GridLayout();
            layout.numColumns = 3;
            group.setLayout((Layout)layout);
            data = new GridData(768);
            group.setLayoutData((Object)data);
            group.setText(SVNUIMessages.DepthSelectionComposite_DepthGroup);
            parent = group;
        } else {
            layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.numColumns = this.supportSetDepth ? 3 : 2;
            this.setLayout((Layout)layout);
            parent = this;
        }
        Label label = new Label((Composite)parent, 0);
        label.setText(SVNUIMessages.RecurseDepthSelector_Label);
        data = new GridData();
        label.setLayoutData((Object)data);
        this.depthSelector = new Combo((Composite)parent, 8);
        this.depthSelector.setText(infinity);
        data = new GridData(768);
        this.depthSelector.setLayoutData((Object)data);
        this.depthSelector.setVisibleItemCount(6);
        if (this.supportSetDepth) {
            this.updateDepthButton = new Button((Composite)parent, 32);
            this.updateDepthButton.setLayoutData((Object)new GridData());
            this.updateDepthButton.setText(SVNUIMessages.DepthSelectionComposite_UpdateDepth);
            this.updateDepthButton.addListener(13, event -> this.refreshStickyDepth());
        }
        if (this.isShowUpdateDepthPath) {
            Label pathLabel = new Label((Composite)parent, 0);
            pathLabel.setLayoutData((Object)new GridData());
            pathLabel.setText(SVNUIMessages.DepthSelectionComposite_PathLabel);
            this.pathInput = new Text((Composite)parent, 2052);
            data = new GridData(768);
            this.pathInput.setLayoutData((Object)data);
            this.pathInput.addModifyListener(e -> {
                String string = this.updatePath = this.pathInput.getText();
            });
            this.browseButton = new Button((Composite)parent, 8);
            this.browseButton.setText(SVNUIMessages.Button_Browse);
            data = new GridData();
            data.widthHint = DefaultDialog.computeButtonWidth(this.browseButton);
            this.browseButton.setLayoutData((Object)data);
            this.browseButton.addListener(13, event -> this.showPathSelectionPanel());
        }
        this.depthSelector.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DepthSelectionComposite.this.depth = ((Combo)e.widget).getItem(((Combo)e.widget).getSelectionIndex()).equals(infinity) ? SVNDepth.INFINITY : (((Combo)e.widget).getItem(((Combo)e.widget).getSelectionIndex()).equals(immediates) ? SVNDepth.IMMEDIATES : (((Combo)e.widget).getItem(((Combo)e.widget).getSelectionIndex()).equals(files) ? SVNDepth.FILES : (((Combo)e.widget).getItem(((Combo)e.widget).getSelectionIndex()).equals(unknown) ? SVNDepth.UNKNOWN : (((Combo)e.widget).getItem(((Combo)e.widget).getSelectionIndex()).equals(exclude) ? SVNDepth.EXCLUDE : SVNDepth.EMPTY))));
            }
        });
        if (this.svn15compatible) {
            this.depthSelector.add(empty);
        }
        this.depthSelector.add(files);
        if (this.svn15compatible) {
            this.depthSelector.add(immediates);
        }
        this.depthSelector.add(infinity);
        if (this.supportSetDepth) {
            this.updateDepthButton.setSelection(this.isStickyDepth);
            this.refreshStickyDepth();
        } else if (this.useWorkingCopyDepth) {
            this.depthSelector.add(unknown);
        }
        this.setDepthComboValue();
    }

    protected void setDepthComboValue() {
        String strDepth;
        switch (this.depth) {
            case INFINITY: {
                strDepth = infinity;
                break;
            }
            case IMMEDIATES: {
                strDepth = immediates;
                break;
            }
            case FILES: {
                strDepth = files;
                break;
            }
            case UNKNOWN: {
                strDepth = unknown;
                break;
            }
            case EXCLUDE: {
                strDepth = exclude;
                break;
            }
            default: {
                strDepth = empty;
            }
        }
        int index = this.depthSelector.indexOf(strDepth);
        if (index == -1) {
            index = 0;
        }
        this.depthSelector.select(index);
    }

    protected void refreshStickyDepth() {
        int selectionIndex;
        int index;
        this.isStickyDepth = this.updateDepthButton.getSelection();
        if (this.isShowUpdateDepthPath) {
            this.pathInput.setEnabled(this.isStickyDepth);
            this.browseButton.setEnabled(this.isStickyDepth);
        }
        if (this.svn16compatible) {
            if (this.isStickyDepth) {
                this.depthSelector.add(exclude);
            } else {
                index = this.depthSelector.indexOf(exclude);
                if (index != -1) {
                    selectionIndex = this.depthSelector.getSelectionIndex();
                    this.depthSelector.remove(index);
                    if (index == selectionIndex) {
                        this.depthSelector.select(0);
                    }
                }
            }
        }
        if (this.useWorkingCopyDepth) {
            if (this.isStickyDepth) {
                index = this.depthSelector.indexOf(unknown);
                if (index != -1) {
                    selectionIndex = this.depthSelector.getSelectionIndex();
                    this.depthSelector.remove(index);
                    if (index == selectionIndex) {
                        this.depthSelector.select(this.depthSelector.indexOf(infinity));
                    }
                }
            } else {
                this.depthSelector.add(unknown);
            }
        }
    }

    protected void showPathSelectionPanel() {
        IRepositoryResource selected;
        RepositoryTreePanel panel = new RepositoryTreePanel(SVNUIMessages.RepositoryResourceSelectionComposite_Select_Title, SVNUIMessages.DepthSelectionComposite_RepositoryPanelDescription, SVNUIMessages.DepthSelectionComposite_RepositoryPanelMessage, new IRepositoryResource[0], false, (IRepositoryBase)this.resource, false);
        DefaultDialog browser = new DefaultDialog(this.getShell(), panel);
        if (browser.open() == 0 && (selected = panel.getSelectedResource()) != null) {
            this.pathInput.setText(selected.getName());
        }
    }

    public SVNDepth getDepth() {
        return this.depth;
    }

    public boolean isStickyDepth() {
        return this.isStickyDepth;
    }

    public String getUpdatePath() {
        return this.updatePath != null ? this.updatePath.trim() : null;
    }
}

