/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.synchronize.variant;

import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.synchronize.variant.ResourceVariant;

public abstract class RemoteResourceVariant
extends ResourceVariant {
    protected static String svnAuthor;

    public RemoteResourceVariant(ILocalResource local) {
        super(local);
        svnAuthor = SVNMessages.SVNInfo_Author;
    }

    @Override
    protected String getCacheId() {
        return "Remote: " + super.getCacheId();
    }

    @Override
    public String getContentIdentifier() {
        if (IStateFilter.SF_PREREPLACED.accept(this.local)) {
            return "";
        }
        Object retVal = super.getContentIdentifier();
        if ((!this.isNotOnRepository() || this.local.isCopied()) && this.local.getAuthor() != null) {
            retVal = (String)retVal + " " + BaseMessages.format(svnAuthor, new Object[]{this.local.getAuthor()});
        }
        return retVal;
    }
}

