/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.operation.IResourcePropertyProvider;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class GetRemotePropertiesOperation
extends AbstractRepositoryOperation
implements IResourcePropertyProvider {
    protected SVNProperty[] properties;

    public GetRemotePropertiesOperation(IRepositoryResource resource) {
        super("Operation_GetRevisionProperties", SVNMessages.class, new IRepositoryResource[]{resource});
    }

    public GetRemotePropertiesOperation(IRepositoryResourceProvider provider) {
        super("Operation_GetRevisionProperties", SVNMessages.class, provider);
    }

    @Override
    public SVNProperty[] getProperties() {
        return this.properties;
    }

    @Override
    public boolean isEditAllowed() {
        return false;
    }

    @Override
    public void refresh() {
    }

    @Override
    public IResource getLocal() {
        return null;
    }

    @Override
    public IRepositoryResource getRemote() {
        return this.operableData()[0];
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource resource = this.operableData()[0];
        this.properties = null;
        IRepositoryLocation location = resource.getRepositoryLocation();
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            this.properties = SVNUtility.properties(proxy, SVNUtility.getEntryRevisionReference(resource), 0L, new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
    }

    @Override
    protected String getShortErrorMessage(Throwable t) {
        return BaseMessages.format(super.getShortErrorMessage(t), new Object[]{this.operableData()[0].getUrl()});
    }
}

