/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.wizard.shareproject;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.svn.core.operation.local.management.ShareProjectOperation;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.RepositoryResourceOnlySelectionComposite;
import org.eclipse.team.svn.ui.extension.impl.ISelectProjectNamePageData;
import org.eclipse.team.svn.ui.verifier.IValidationManager;

public class SelectProjectNamePageSimpleModeComposite
extends Composite
implements ISelectProjectNamePageData {
    protected RepositoryResourceOnlySelectionComposite resourceSelectionComposite;
    protected IValidationManager validationManager;
    protected IRepositoryLocation location;
    protected boolean multiProject;
    protected List<Control> controls = new ArrayList<Control>();

    public SelectProjectNamePageSimpleModeComposite(Composite parent, int style, IValidationManager validationManager) {
        super(parent, style);
        this.validationManager = validationManager;
        this.createControls();
    }

    @Override
    public void setProjectsAndLocation(IProject[] projects, IRepositoryLocation location, boolean multiProject) {
        this.location = location;
        this.multiProject = multiProject;
        IRepositoryContainer baseResource = location.asRepositoryContainer(location.getUrl(), false);
        this.resourceSelectionComposite.setBaseResource((IRepositoryResource)baseResource);
        this.resourceSelectionComposite.setMatchToBaseResource(true);
        IProject pr = projects[0];
        Object url = baseResource.getUrl();
        if (!this.multiProject) {
            url = (String)url + "/" + pr.getName();
        }
        this.resourceSelectionComposite.setUrl((String)url);
    }

    protected void createControls() {
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        GridData gridData = new GridData();
        this.setLayoutData(gridData);
        IRepositoryResource baseResource = null;
        this.resourceSelectionComposite = new RepositoryResourceOnlySelectionComposite(this, 0, this.validationManager, "selectProjectNamePage", baseResource, SVNUIMessages.SelectProjectNamePage_Select_Title, SVNUIMessages.SelectProjectNamePage_Select_Description);
        GridData data = new GridData(768);
        data.widthHint = 550;
        this.resourceSelectionComposite.setLayoutData(data);
        this.controls.add((Control)this.resourceSelectionComposite);
    }

    @Override
    public ShareProjectOperation.IFolderNameMapper getSelectedNames() {
        return project -> {
            Object folderName = null;
            String toTrim = this.location.getUrl();
            String selectedUrl = this.resourceSelectionComposite.getSelectedResource().getUrl();
            if ((selectedUrl = SVNUtility.normalizeURL((String)selectedUrl)).startsWith(toTrim)) {
                Object object = folderName = selectedUrl.equals(toTrim) ? "" : selectedUrl.substring(toTrim.length() + 1);
                if (this.multiProject) {
                    folderName = (String)folderName + "/" + project.getName();
                }
            } else {
                throw new RuntimeException("Inconsistent repository location and selected repository url. Selected url: " + selectedUrl + ", repository location: " + toTrim);
            }
            return folderName;
        };
    }

    @Override
    public String getRootProjectName() {
        return null;
    }

    @Override
    public void save() {
        this.resourceSelectionComposite.saveHistory();
    }

    @Override
    public int getLayoutType() {
        return 0;
    }

    @Override
    public boolean isManagementFoldersEnabled() {
        return false;
    }

    @Override
    public void validateContent() {
        this.validationManager.validateContent();
    }

    @Override
    public IRepositoryLocation getRepositoryLocation() {
        return this.location;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.controls != null && !this.controls.isEmpty()) {
            for (Control control : this.controls) {
                control.setEnabled(enabled);
            }
        }
    }
}

