/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.verifier;

import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.verifier.AbstractFormattedVerifier;

public class PropertyVerifier
extends AbstractFormattedVerifier {
    private IRepositoryResource base;
    private Pattern pattern;
    private String propName;
    private boolean toValidate;

    public PropertyVerifier(String fieldName, String regExp, String propName, IRepositoryResource base) {
        super(fieldName);
        if (regExp == null) {
            this.toValidate = false;
        } else {
            this.toValidate = true;
            this.pattern = Pattern.compile(regExp);
        }
        this.base = base;
        String[] parts = propName.split(":");
        this.propName = "";
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            this.propName = String.valueOf(this.propName) + part;
            ++n2;
        }
    }

    @Override
    protected String getErrorMessageImpl(Control input) {
        if (!this.toValidate || this.propName.equals("svnlog") || this.propName.equals("svnauthor")) {
            return null;
        }
        String inputText = this.getText(input);
        if (this.propName.equals("bugtraqlogregex")) {
            try {
                String[] logs;
                String[] stringArray = logs = inputText.split("\r\n");
                int n = logs.length;
                int n2 = 0;
                while (n2 < n) {
                    String log = stringArray[n2];
                    Pattern.compile(log);
                    ++n2;
                }
            }
            catch (Exception exception) {
                return SVNUIMessages.getString("PropertyEditPanel_Verifier_" + this.propName);
            }
            return null;
        }
        if (this.propName.equals("bugtraqmessage")) {
            if (!inputText.contains("%BUGID%")) {
                return SVNUIMessages.getString("PropertyEditPanel_Verifier_" + this.propName);
            }
            return null;
        }
        if (this.propName.equals("svnexternals")) {
            try {
                SVNUtility.parseSVNExternalsProperty((String)inputText, (IRepositoryResource)this.base);
            }
            catch (Exception exception) {
                return SVNUIMessages.getString("PropertyEditPanel_Verifier_" + this.propName);
            }
            return null;
        }
        if (this.propName.equals("svndate")) {
            try {
                new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(inputText);
            }
            catch (Exception exception) {
                return BaseMessages.format((String)("PropertyEditPanel_Verifier_" + this.propName), (Object[])new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"});
            }
            return null;
        }
        Matcher matcher = this.pattern.matcher(inputText);
        if (!matcher.matches()) {
            String retVal = SVNUIMessages.getString("PropertyEditPanel_Verifier_" + this.propName);
            if (retVal.equals("PropertyEditPanel_Verifier_" + this.propName)) {
                return BaseMessages.format((String)SVNUIMessages.PropertyEditPanel_regExp_Verifier, (Object[])new String[]{this.pattern.pattern()});
            }
            return SVNUIMessages.getString("PropertyEditPanel_Verifier_" + this.propName);
        }
        return null;
    }

    @Override
    protected String getWarningMessageImpl(Control input) {
        if (!this.toValidate) {
            return null;
        }
        if (this.propName.equals("svnauthor") || this.propName.equals("svnlog") || this.propName.equals("svndate")) {
            return SVNUIMessages.getString("PropertyEditPanel_Verifier_Warning_" + this.propName);
        }
        return null;
    }
}

