/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.participant;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.panel.local.CommitPanel;
import org.eclipse.team.svn.ui.panel.participant.BasePaneParticipant;
import org.eclipse.team.svn.ui.synchronize.AbstractSynchronizeActionGroup;
import org.eclipse.team.svn.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.eclipse.team.svn.ui.synchronize.action.CleanUpAction;
import org.eclipse.team.svn.ui.synchronize.action.CompareWithLatestRevisionPaneAction;
import org.eclipse.team.svn.ui.synchronize.action.CompareWithRevisionPaneAction;
import org.eclipse.team.svn.ui.synchronize.action.CompareWithWorkingCopyPaneAction;
import org.eclipse.team.svn.ui.synchronize.action.CreateBranchAction;
import org.eclipse.team.svn.ui.synchronize.action.CreatePatchFileAction;
import org.eclipse.team.svn.ui.synchronize.action.DeletePaneAction;
import org.eclipse.team.svn.ui.synchronize.action.EditConflictsAction;
import org.eclipse.team.svn.ui.synchronize.action.EditTreeConflictsAction;
import org.eclipse.team.svn.ui.synchronize.action.ExtractOutgoingToAction;
import org.eclipse.team.svn.ui.synchronize.action.OpenInComparePaneAction;
import org.eclipse.team.svn.ui.synchronize.action.ReplaceWithLatestRevisionPaneAction;
import org.eclipse.team.svn.ui.synchronize.action.ReplaceWithRevisionPaneAction;
import org.eclipse.team.svn.ui.synchronize.action.RevertAction;
import org.eclipse.team.svn.ui.synchronize.update.action.LockAction;
import org.eclipse.team.svn.ui.synchronize.update.action.MarkAsMergedAction;
import org.eclipse.team.svn.ui.synchronize.update.action.UnlockAction;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;

public class CommitPaneParticipant
extends BasePaneParticipant {
    protected CommitPanel commitPanel;

    public CommitPaneParticipant(ISynchronizeScope scope, CommitPanel commitPanel) {
        super(scope, commitPanel);
        this.commitPanel = commitPanel;
    }

    @Override
    protected Collection<AbstractSynchronizeActionGroup> getActionGroups() {
        ArrayList<AbstractSynchronizeActionGroup> actionGroups = new ArrayList<AbstractSynchronizeActionGroup>();
        actionGroups.add(new CommitPaneActionGroup(this.commitPanel));
        return actionGroups;
    }

    protected static class CommitPaneActionGroup
    extends BasePaneParticipant.BasePaneActionGroup {
        protected MenuManager compareWithGroup;
        protected MenuManager replaceWithGroup;
        protected CommitPanel commitPanel;

        public CommitPaneActionGroup(CommitPanel commitPanel) {
            super(commitPanel);
            this.commitPanel = commitPanel;
        }

        @Override
        protected void configureActions(ISynchronizePageConfiguration configuration) {
            super.configureActions(configuration);
            final OpenInComparePaneAction openInCompareAction = new OpenInComparePaneAction(configuration);
            configuration.setProperty("org.eclipse.team.ui.P_OPEN_ACTION", (Object)new Action(){

                public void run() {
                    openInCompareAction.run();
                }
            });
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "syncNormal", (IContributionItem)new Separator());
            AbstractSynchronizeModelAction pasteSelectedNamesAction = new AbstractSynchronizeModelAction(SVNUIMessages.CommitPanel_PasteNames_Action, configuration){

                @Override
                protected IActionOperation getOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
                    commitPanel.pasteNames();
                    return null;
                }
            };
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "syncNormal", (IAction)pasteSelectedNamesAction);
            CreatePatchFileAction patchAction = new CreatePatchFileAction(SVNUIMessages.CreatePatchCommand_label, configuration);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "syncNormal", (IAction)patchAction);
            CreateBranchAction branchAction = new CreateBranchAction(SVNUIMessages.SynchronizeActionGroup_Branch, configuration);
            branchAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/actions/branch.gif"));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "syncNormal", (IAction)branchAction);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "syncNormal", (IContributionItem)new Separator());
            RevertAction revertAction = new RevertAction(SVNUIMessages.SynchronizeActionGroup_Revert, configuration);
            revertAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/actions/revert.gif"));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "syncNormal", (IAction)revertAction);
            EditConflictsAction editConflictsAction = new EditConflictsAction(SVNUIMessages.UpdateActionGroup_EditConflicts, configuration);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "syncNormal", (IAction)editConflictsAction);
            EditTreeConflictsAction editTreeConflictsAction = new EditTreeConflictsAction(SVNUIMessages.UpdateActionGroup_EditTreeConflicts, configuration);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "syncNormal", (IAction)editTreeConflictsAction);
            MarkAsMergedAction markMergedAction = new MarkAsMergedAction(SVNUIMessages.SynchronizeActionGroup_MarkAsMerged, configuration);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "syncNormal", (IAction)markMergedAction);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "syncNormal", (IContributionItem)new Separator());
            LockAction lockAction = new LockAction(SVNUIMessages.UpdateActionGroup_Lock, configuration);
            lockAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/actions/lock.gif"));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "syncNormal", (IAction)lockAction);
            UnlockAction unlockAction = new UnlockAction(SVNUIMessages.UpdateActionGroup_Unlock, configuration);
            unlockAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/actions/unlock.gif"));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "syncNormal", (IAction)unlockAction);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "syncNormal", (IContributionItem)new Separator());
            this.compareWithGroup = new MenuManager(SVNUIMessages.CommitPanel_CompareWith_Group);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "syncNormal", (IContributionItem)this.compareWithGroup);
            CompareWithWorkingCopyPaneAction compareWithWorkingCopyAction = new CompareWithWorkingCopyPaneAction(SVNUIMessages.CompareWithWorkingCopyAction_label, configuration);
            this.compareWithGroup.add((IAction)compareWithWorkingCopyAction);
            CompareWithLatestRevisionPaneAction compareWithLatestRevisionPaneAction = new CompareWithLatestRevisionPaneAction(SVNUIMessages.CompareWithLatestRevisionAction_label, configuration);
            this.compareWithGroup.add((IAction)compareWithLatestRevisionPaneAction);
            CompareWithRevisionPaneAction compareWithRevisionPaneAction = new CompareWithRevisionPaneAction(SVNUIMessages.CompareWithRevisionAction_label, configuration);
            this.compareWithGroup.add((IAction)compareWithRevisionPaneAction);
            this.replaceWithGroup = new MenuManager(SVNUIMessages.CommitPanel_ReplaceWith_Group);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "syncNormal", (IContributionItem)this.replaceWithGroup);
            ReplaceWithLatestRevisionPaneAction replaceWithLatestRevisionPaneAction = new ReplaceWithLatestRevisionPaneAction(SVNUIMessages.ReplaceWithLatestRevisionAction_label, configuration);
            this.replaceWithGroup.add((IAction)replaceWithLatestRevisionPaneAction);
            ReplaceWithRevisionPaneAction replaceWithRevisionPaneAction = new ReplaceWithRevisionPaneAction(SVNUIMessages.ReplaceWithRevisionAction_label, configuration);
            this.replaceWithGroup.add((IAction)replaceWithRevisionPaneAction);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "syncNormal", (IContributionItem)new Separator());
            ExtractOutgoingToAction extractActionOutgoing = new ExtractOutgoingToAction(SVNUIMessages.ExtractToAction_Label, configuration);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "syncNormal", (IAction)extractActionOutgoing);
            CleanUpAction cleanUpAction = new CleanUpAction(SVNUIMessages.SynchronizeActionGroup_Cleanup, configuration);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "syncNormal", (IAction)cleanUpAction);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "syncNormal", (IContributionItem)new Separator());
            DeletePaneAction deleteAction = new DeletePaneAction(SVNUIMessages.CommitPanel_Delete_Action, configuration);
            deleteAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/delete.gif"));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "syncNormal", (IAction)deleteAction);
        }

        @Override
        public void dispose() {
            if (this.compareWithGroup != null) {
                this.compareWithGroup.removeAll();
                this.compareWithGroup.dispose();
            }
            if (this.replaceWithGroup != null) {
                this.replaceWithGroup.removeAll();
                this.replaceWithGroup.dispose();
            }
            super.dispose();
        }
    }
}

