/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.local;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.connector.ISVNManager;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.management.AddRepositoryLocationOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.PathSelectionComposite;
import org.eclipse.team.svn.ui.dialog.NonValidLocationErrorDialog;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class AddRepositoryPanel
extends AbstractDialogPanel {
    protected PathSelectionComposite pathSelectionComposite;
    protected Button createRepositoryLocaton;
    protected Button fsfsButton;
    protected Button bdbButton;
    protected IActionOperation operationToPerform;

    public AddRepositoryPanel() {
        this.dialogTitle = SVNUIMessages.AddRepositoryPage_Title;
        this.dialogDescription = SVNUIMessages.AddRepositoryPage_Description;
        this.defaultMessage = SVNUIMessages.AddRepositoryPage_Message;
    }

    @Override
    protected void createControlsImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.pathSelectionComposite = new PathSelectionComposite(SVNUIMessages.AddRepositoryPage_RepositoryPath_Label, SVNUIMessages.AddRepositoryPage_RepositoryPath_Name, SVNUIMessages.AddRepositoryPage_DirectoryDialog_Title, SVNUIMessages.AddRepositoryPage_DirectoryDialog_Description, true, composite, this);
        Group typeGroup = new Group(composite, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 40;
        layout.numColumns = 2;
        typeGroup.setLayout((Layout)layout);
        data = new GridData(768);
        typeGroup.setLayoutData((Object)data);
        typeGroup.setText(SVNUIMessages.AddRepositoryPage_RepositoryType_Group);
        this.fsfsButton = new Button((Composite)typeGroup, 16);
        data = new GridData();
        this.fsfsButton.setLayoutData((Object)data);
        this.fsfsButton.setText(SVNUIMessages.AddRepositoryPage_FileSystem_Button);
        this.fsfsButton.setSelection(true);
        this.bdbButton = new Button((Composite)typeGroup, 16);
        data = new GridData();
        this.bdbButton.setLayoutData((Object)data);
        this.bdbButton.setText(SVNUIMessages.AddRepositoryPage_BerkeleyDB_Button);
        int features = CoreExtensionsManager.instance().getSVNConnectorFactory().getSupportedFeatures();
        if ((features & 8) == 0) {
            this.fsfsButton.setSelection(false);
            this.fsfsButton.setEnabled(false);
            this.bdbButton.setSelection(true);
        }
        if ((features & 0x10) == 0) {
            this.bdbButton.setSelection(false);
            this.bdbButton.setEnabled(false);
        }
        this.createRepositoryLocaton = new Button(composite, 32);
        data = new GridData();
        this.createRepositoryLocaton.setLayoutData((Object)data);
        this.createRepositoryLocaton.setText(SVNUIMessages.AddRepositoryPage_CreateRepositoryLocation_Button);
        this.createRepositoryLocaton.setSelection(true);
    }

    public String getRepositoryPath() {
        return this.pathSelectionComposite.getSelectedPath();
    }

    public ISVNManager.RepositoryKind getRepositoryType() {
        return this.fsfsButton.getSelection() ? ISVNManager.RepositoryKind.FSFS : ISVNManager.RepositoryKind.BDB;
    }

    public boolean isCreateRepositoryLocation() {
        return this.createRepositoryLocaton.getSelection();
    }

    public boolean performFinish() {
        final ISVNManager.RepositoryKind repositoryType = this.getRepositoryType();
        File repositoryPathFile = new File(this.getRepositoryPath());
        final String repositoryPath = repositoryPathFile.isAbsolute() ? this.getRepositoryPath() : repositoryPathFile.getAbsolutePath();
        Object url = "file:///" + repositoryPath;
        url = SVNUtility.normalizeURL((String)url);
        final IRepositoryLocation location = SVNRemoteStorage.instance().newRepositoryLocation();
        SVNUtility.initializeRepositoryLocation((IRepositoryLocation)location, (String)url);
        AbstractActionOperation mainOp = new AbstractActionOperation("Operation_CreateRepository", SVNUIMessages.class){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                ISVNManager proxy = CoreExtensionsManager.instance().getSVNConnectorFactory().createManager();
                try {
                    StringBuilder msg = new StringBuilder();
                    msg.append("svnadmin create").append(" ");
                    msg.append("--fs-type ").append(repositoryType).append(" ");
                    if (ISVNManager.RepositoryKind.BDB == repositoryType) {
                        msg.append("--bdb-txn-nosync").append(" ");
                        msg.append("--bdb-log-keep").append(" ");
                    }
                    msg.append("\"").append(FileUtility.normalizePath((String)repositoryPath)).append("\"");
                    msg.append("\n");
                    this.writeToConsole(0, msg.toString());
                    proxy.create(repositoryPath, repositoryType, null, 0L, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)this, monitor, null));
                }
                finally {
                    proxy.dispose();
                }
            }
        };
        CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
        op.add((IActionOperation)mainOp);
        if (this.isCreateRepositoryLocation()) {
            op.add((IActionOperation)new AbstractActionOperation("Operation_AddRepositoryLocation", SVNUIMessages.class){

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    boolean[] isAddLocation = new boolean[]{true};
                    Exception validationException = SVNUtility.validateRepositoryLocation((IRepositoryLocation)location, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)this, monitor, null));
                    if (validationException != null) {
                        UIMonitorUtility.getDisplay().syncExec(() -> {
                            Shell shell = AddRepositoryPanel.this.manager.getShell() != null ? AddRepositoryPanel.this.manager.getShell() : UIMonitorUtility.getShell();
                            NonValidLocationErrorDialog dialog = new NonValidLocationErrorDialog(shell, validationException.getMessage());
                            if (dialog.open() != 0) {
                                blArray[0] = false;
                            }
                        });
                    }
                    if (isAddLocation[0]) {
                        AddRepositoryLocationOperation addLocationOperation = new AddRepositoryLocationOperation(location);
                        ProgressMonitorUtility.doTaskExternal((IActionOperation)addLocationOperation, (IProgressMonitor)monitor);
                    }
                }
            }, new IActionOperation[]{mainOp});
        }
        this.operationToPerform = op;
        return true;
    }

    public IActionOperation getOperationToPeform() {
        return this.operationToPerform;
    }

    @Override
    protected void cancelChangesImpl() {
        this.operationToPerform = null;
    }

    @Override
    protected void saveChangesImpl() {
        this.performFinish();
    }

    @Override
    public String getHelpId() {
        return "org.eclipse.team.svn.help.addRepositoryContext";
    }
}

