/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.SVNCommitStatus;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IPostCommitErrorsProvider;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.operation.local.CommitOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.RevertOperation;
import org.eclipse.team.svn.core.operation.local.UpdateOperation;
import org.eclipse.team.svn.core.operation.local.change.FolderChange;
import org.eclipse.team.svn.core.operation.local.change.IActionOperationProcessor;
import org.eclipse.team.svn.core.operation.local.change.ResourceChange;
import org.eclipse.team.svn.core.operation.local.change.visitors.CompositeVisitor;
import org.eclipse.team.svn.core.operation.local.change.visitors.RemoveNonVersionedVisitor;
import org.eclipse.team.svn.core.operation.local.change.visitors.RestoreContentVisitor;
import org.eclipse.team.svn.core.operation.local.change.visitors.RestorePropertiesVisitor;
import org.eclipse.team.svn.core.operation.local.change.visitors.SaveContentVisitor;
import org.eclipse.team.svn.core.operation.local.change.visitors.SavePropertiesVisitor;
import org.eclipse.team.svn.core.operation.local.refactor.DeleteResourceOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.core.synchronize.UpdateSubscriber;
import org.eclipse.team.svn.core.utility.FileUtility;

public class MarkAsMergedOperation
extends AbstractWorkingCopyOperation
implements IActionOperationProcessor,
IResourceProvider,
IPostCommitErrorsProvider {
    protected boolean override;
    protected boolean keepLocks;
    protected String overrideMessage;
    protected IResource[] committables = new IResource[0];
    protected IResource[] withDifferentNodeKind = new IResource[0];
    protected boolean ignoreExternals;
    protected ArrayList<SVNCommitStatus> postCommitErrors;

    public MarkAsMergedOperation(IResource[] resources, boolean override, String overrideMessage, boolean ignoreExternals) {
        this(resources, override, overrideMessage, false, ignoreExternals);
    }

    public MarkAsMergedOperation(IResource[] resources, boolean override, String overrideMessage, boolean keepLocks, boolean ignoreExternals) {
        super("Operation_MarkAsMerged", SVNMessages.class, resources);
        this.override = override;
        this.overrideMessage = overrideMessage;
        this.keepLocks = keepLocks;
        this.ignoreExternals = ignoreExternals;
    }

    public MarkAsMergedOperation(IResourceProvider provider, boolean override, String overrideMessage, boolean keepLocks, boolean ignoreExternals) {
        super("Operation_MarkAsMerged", SVNMessages.class, provider);
        this.override = override;
        this.overrideMessage = overrideMessage;
        this.keepLocks = keepLocks;
        this.ignoreExternals = ignoreExternals;
    }

    public MarkAsMergedOperation(IResourceProvider provider, boolean override, String overrideMessage, boolean ignoreExternals) {
        this(provider, override, overrideMessage, false, ignoreExternals);
    }

    @Override
    public IResource[] getResources() {
        return this.committables;
    }

    public IResource[] getHavingDifferentNodeKind() {
        return this.withDifferentNodeKind;
    }

    @Override
    public SVNCommitStatus[] getPostCommitErrors() {
        return this.postCommitErrors == null ? null : this.postCommitErrors.toArray(new SVNCommitStatus[this.postCommitErrors.size()]);
    }

    @Override
    public void doOperation(IActionOperation op, IProgressMonitor monitor) {
        this.reportStatus(op.run(monitor).getStatus());
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = FileUtility.shrinkChildNodesWithSwitched(this.operableData());
        ArrayList committables = new ArrayList();
        ArrayList withDifferentNodeKind = new ArrayList();
        this.postCommitErrors = new ArrayList();
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            IResource current = resources[i];
            this.protectStep(monitor1 -> {
                ILocalResource local = SVNRemoteStorage.instance().asLocalResourceAccessible(current);
                if (IStateFilter.SF_DELETED.accept(local) && !IStateFilter.SF_PREREPLACEDREPLACED.accept(local)) {
                    this.markDeleted(local, (IProgressMonitor)new NullProgressMonitor());
                    committables.add(local.getResource());
                } else if (!IStateFilter.SF_INTERNAL_INVALID.accept(local)) {
                    if ((local.getChangeMask() & 0x20) != 0) {
                        this.doOperation(new RevertOperation(new IResource[]{local.getResource()}, true), monitor1);
                        this.doOperation(new RefreshResourcesOperation(new IResource[]{local.getResource()}, 2, RefreshResourcesOperation.REFRESH_ALL), monitor1);
                    } else {
                        boolean nodeKindChanged = this.markExisting(local, monitor1);
                        if (!nodeKindChanged) {
                            committables.add(local.getResource());
                        } else {
                            withDifferentNodeKind.add(local.getResource());
                        }
                    }
                }
            }, monitor, resources.length);
            ++i;
        }
        this.committables = committables.toArray(new IResource[committables.size()]);
        this.withDifferentNodeKind = withDifferentNodeKind.toArray(new IResource[withDifferentNodeKind.size()]);
    }

    protected void markDeleted(ILocalResource local, IProgressMonitor monitor) throws Exception {
        this.doOperation(new RevertOperation(new IResource[]{local.getResource()}, true), monitor);
        this.doOperation(new UpdateOperation(new IResource[]{local.getResource()}, this.getRevisionToUpdate(local), this.ignoreExternals), monitor);
        File f = new File(FileUtility.getWorkingCopyPath(local.getResource()));
        if (f.exists()) {
            this.doOperation(new DeleteResourceOperation(local.getResource()), monitor);
        }
    }

    protected boolean markExisting(ILocalResource local, IProgressMonitor monitor) throws Exception {
        boolean nodeKindChanged = false;
        ResourceChange change = ResourceChange.wrapLocalResource(null, local, true);
        try {
            CompositeVisitor visitor = new CompositeVisitor();
            visitor.add(new SavePropertiesVisitor());
            visitor.add(new SaveContentVisitor());
            change.traverse(visitor, 2, this, monitor);
            if (FileUtility.checkForResourcesPresenceRecursive(new IResource[]{local.getResource()}, IStateFilter.SF_REVERTABLE)) {
                this.doOperation(new RevertOperation(new IResource[]{local.getResource()}, true), monitor);
            }
            change.traverse(new RemoveNonVersionedVisitor(true), 2, this, monitor);
            this.doOperation(new UpdateOperation(new IResource[]{local.getResource()}, this.getRevisionToUpdate(local), this.ignoreExternals), monitor);
            String wcPath = FileUtility.getWorkingCopyPath(local.getResource());
            boolean isLocalExists = new File(wcPath).exists();
            if (this.override && isLocalExists) {
                nodeKindChanged = this.prepareToOverride(change, monitor);
                if (new File(wcPath).exists()) {
                    CommitOperation op = new CommitOperation(new IResource[]{local.getResource()}, this.overrideMessage, true, this.keepLocks);
                    this.doOperation(op, monitor);
                    SVNCommitStatus[] errors = op.getPostCommitErrors();
                    if (errors != null) {
                        this.postCommitErrors.addAll(Arrays.asList(errors));
                    }
                }
            }
            visitor = new CompositeVisitor();
            visitor.add(new RestoreContentVisitor(nodeKindChanged));
            visitor.add(new RestorePropertiesVisitor());
            change.traverse(visitor, 2, this, monitor);
        }
        finally {
            change.disposeChangeModel(monitor);
        }
        return nodeKindChanged;
    }

    protected SVNRevision getRevisionToUpdate(ILocalResource local) throws Exception {
        AbstractSVNSyncInfo syncInfo = (AbstractSVNSyncInfo)UpdateSubscriber.instance().getSyncInfo(local.getResource());
        long revNum = -1L;
        if (syncInfo != null) {
            ILocalResource remoteResource = syncInfo.getRemoteChangeResource();
            revNum = remoteResource.getRevision();
        }
        return revNum == -1L ? SVNRevision.HEAD : SVNRevision.fromNumber(revNum);
    }

    protected boolean prepareToOverride(ResourceChange change, IProgressMonitor monitor) {
        boolean nodeKindBeforeUpdate = change instanceof FolderChange;
        if (nodeKindBeforeUpdate) {
            ResourceChange[] children;
            ResourceChange[] resourceChangeArray = children = ((FolderChange)change).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceChange child = resourceChangeArray[n2];
                this.prepareToOverride(child, monitor);
                ++n2;
            }
        }
        ILocalResource local = change.getLocal();
        File real = new File(FileUtility.getWorkingCopyPath(local.getResource()));
        boolean nodeKindChanged = false;
        if (real.exists()) {
            nodeKindChanged = nodeKindBeforeUpdate ^ real.isDirectory();
            if (IStateFilter.SF_NOTONREPOSITORY.accept(local) || nodeKindChanged) {
                this.doOperation(new DeleteResourceOperation(local.getResource()), monitor);
            }
        }
        return nodeKindChanged;
    }
}

