/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNEntryStatusCallback;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.file.AbstractFileOperation;
import org.eclipse.team.svn.core.operation.file.IFileProvider;
import org.eclipse.team.svn.core.operation.file.SVNFileStorage;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;

public abstract class AbstractStatusOperation
extends AbstractFileOperation {
    protected SVNChangeStatus[] statuses;
    protected boolean recursive;

    public AbstractStatusOperation(String operationName, Class<? extends NLS> messagesClass, File[] files, boolean recursive) {
        super(operationName, messagesClass, files);
        this.recursive = recursive;
    }

    public AbstractStatusOperation(String operationName, Class<? extends NLS> messagesClass, IFileProvider provider, boolean recursive) {
        super(operationName, messagesClass, provider);
        this.recursive = recursive;
    }

    public SVNChangeStatus[] getStatuses() {
        return this.statuses;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File[] files = this.operableData();
        ArrayList result = new ArrayList();
        ArrayList conflicts = new ArrayList();
        ISVNEntryStatusCallback cb = status -> {
            result.add(status);
            if (status.hasConflict && status.treeConflicts == null) {
                conflicts.add(status);
            }
        };
        int i = 0;
        while (i < files.length && !monitor.isCanceled()) {
            IRepositoryResource remote = SVNFileStorage.instance().asRepositoryResource(files[i], false);
            IRepositoryLocation location = remote.getRepositoryLocation();
            ISVNConnector proxy = location.acquireSVNProxy();
            conflicts.clear();
            this.reportStatuses(proxy, cb, files[i], monitor, files.length);
            Iterator it = conflicts.iterator();
            while (it.hasNext() && !monitor.isCanceled()) {
                SVNChangeStatus svnChangeStatus = (SVNChangeStatus)it.next();
                this.protectStep(monitor1 -> proxy.getInfo(new SVNEntryRevisionReference(sVNChangeStatus.path), SVNDepth.EMPTY, 0x1000000000L, null, info -> svnChangeStatus.setTreeConflicts(info.treeConflicts), new SVNProgressMonitor(this, monitor1, null, false)), monitor, files.length);
            }
            location.releaseSVNProxy(proxy);
            ++i;
        }
        this.statuses = result.toArray(new SVNChangeStatus[result.size()]);
    }

    protected void reportStatuses(ISVNConnector proxy, ISVNEntryStatusCallback cb, File current, IProgressMonitor monitor, int tasks) {
        this.protectStep(monitor1 -> proxy.status(current.getAbsolutePath(), SVNDepth.infinityOrImmediates(this.recursive), this.isRemote() ? 64L : 0x200000000L, null, cb, new SVNProgressMonitor(this, monitor1, null, false)), monitor, tasks);
    }

    protected abstract boolean isRemote();
}

