/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.svn.core.operation.file.AbstractFileOperation;
import org.eclipse.team.svn.core.operation.file.IFileProvider;
import org.eclipse.team.svn.core.operation.file.IUnresolvedConflictDetector;

public abstract class AbstractFileConflictDetectionOperation
extends AbstractFileOperation
implements IUnresolvedConflictDetector {
    protected Set processed;
    protected Set unprocessed;
    protected boolean hasUnresolvedConflict;
    protected String conflictMessage;

    public AbstractFileConflictDetectionOperation(String operationName, Class<? extends NLS> messagesClass, File[] files) {
        super(operationName, messagesClass, files);
    }

    public AbstractFileConflictDetectionOperation(String operationName, Class<? extends NLS> messagesClass, IFileProvider provider) {
        super(operationName, messagesClass, provider);
    }

    @Override
    public boolean hasUnresolvedConflicts() {
        return this.hasUnresolvedConflict;
    }

    @Override
    public String getMessage() {
        return this.conflictMessage;
    }

    @Override
    public File[] getProcessed() {
        return this.processed == null ? null : this.processed.toArray(new File[this.processed.size()]);
    }

    @Override
    public File[] getUnprocessed() {
        return this.unprocessed == null ? null : this.unprocessed.toArray(new File[this.unprocessed.size()]);
    }

    protected void defineInitialResourceSet(File[] resources) {
        this.hasUnresolvedConflict = false;
        this.unprocessed = new HashSet();
        this.processed = new HashSet();
        this.processed.addAll(Arrays.asList(resources));
    }
}

