/*******************************************************************************
 * Copyright (c) 2005, 2023 Polarion Software and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * https://www.eclipse.org/legal/epl-2.0
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Alexander Gurov (Polarion Software) - initial API and implementation
 *    Alexander Fedorov (ArSysOp) - ongoing support
 *******************************************************************************/

package org.eclipse.team.svn.core.extension.options;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

/**
 * Allows to define dynamically resource ignore rules
 * 
 * @author Alexander Gurov
 */
public interface IIgnoreRecommendations {
	/**
	 * Tells if the given resource can be processed by recommendation provider
	 * 
	 * @param resource
	 *            resource to be processed
	 * @return true if and only if the given resource can be processed by recommendation provider
	 * @throws CoreException
	 */
	boolean isAcceptableNature(IResource resource) throws CoreException;

	/**
	 * Tells if ignore is recommended for the given resource
	 * 
	 * @param resource
	 *            resource to be processed
	 * @return true if and only if ignore is recommended for the given resource
	 * @throws CoreException
	 */
	boolean isIgnoreRecommended(IResource resource) throws CoreException;

	/**
	 * Tells if resource is autogenerated output
	 * 
	 * @param resource
	 *            resource to be processed
	 * @return true if and only if resource is autogenerated output
	 * @throws CoreException
	 */
	boolean isOutput(IResource resource) throws CoreException;
}
