/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class LocateProjectsOperation
extends AbstractRepositoryOperation
implements IRepositoryResourceProvider {
    public static final int LEVEL_ALL = -1;
    protected IRepositoryResource[] foundProjects;
    protected ILocateFilter filter;
    protected int levelLimitation;

    public LocateProjectsOperation(IRepositoryResource[] startFrom, ILocateFilter filter) {
        this(startFrom, filter, -1);
    }

    public LocateProjectsOperation(IRepositoryResource[] startFrom, ILocateFilter filter, int limitation) {
        super("Operation_LocateProjects", SVNMessages.class, startFrom);
        this.levelLimitation = limitation;
        this.filter = filter;
    }

    @Override
    public IRepositoryResource[] getRepositoryResources() {
        return this.foundProjects;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource[] baseFolders = SVNUtility.shrinkChildNodes(this.operableData());
        int i = 0;
        while (i < baseFolders.length) {
            SVNRevision selectedRevision = baseFolders[i].getSelectedRevision();
            SVNRevision pegRevision = baseFolders[i].getPegRevision();
            baseFolders[i] = baseFolders[i].getRepositoryLocation().asRepositoryContainer(baseFolders[i].getUrl(), false);
            baseFolders[i].setSelectedRevision(selectedRevision);
            baseFolders[i].setPegRevision(pegRevision);
            ++i;
        }
        ArrayList<IRepositoryResource> found = new ArrayList<IRepositoryResource>();
        this.findProjects(monitor, found, baseFolders, 0);
        this.foundProjects = found.toArray(new IRepositoryResource[found.size()]);
    }

    protected void findProjects(IProgressMonitor monitor, List<IRepositoryResource> found, IRepositoryResource[] baseFolders, int level) throws Exception {
        int i = 0;
        while (i < baseFolders.length && !monitor.isCanceled()) {
            IRepositoryResource current = baseFolders[i];
            if (this.isCheckEnabled(level, current)) {
                this.protectStep(monitor1 -> {
                    if (current instanceof IRepositoryContainer) {
                        IRepositoryResource[] children;
                        String message = this.getOperationResource("Scanning");
                        ProgressMonitorUtility.setTaskInfo(monitor1, this, BaseMessages.format(message, new Object[]{current.getUrl()}));
                        IRepositoryResource[] iRepositoryResourceArray = children = ((IRepositoryContainer)current).getChildren();
                        int n2 = children.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            IRepositoryResource child = iRepositoryResourceArray[n3];
                            child.setPegRevision(current.getSelectedRevision());
                            ++n3;
                        }
                        if (this.filter.isProject(current, children)) {
                            found.add(current);
                        } else if (this.isRecursionEnabled(level)) {
                            this.findProjects(monitor1, found, children, level + 1);
                        }
                    }
                }, monitor, baseFolders.length);
            }
            ++i;
        }
    }

    protected boolean isCheckEnabled(int level, IRepositoryResource current) {
        IRepositoryLocation location;
        return level <= 0 || !(location = current.getRepositoryLocation()).isStructureEnabled() || !current.getName().equals(location.getBranchesLocation()) && !current.getName().equals(location.getTagsLocation());
    }

    protected boolean isRecursionEnabled(int level) {
        return this.levelLimitation <= -1 || level < this.levelLimitation;
    }

    public static interface ILocateFilter {
        public boolean isProject(IRepositoryResource var1, IRepositoryResource[] var2);
    }
}

