/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.connector;

import org.eclipse.team.svn.core.connector.SVNRevision;

public class SVNRevisionRange {
    public final SVNRevision from;
    public final SVNRevision to;
    public final boolean inheritable;

    public SVNRevisionRange(long from, long to) {
        this(from, to, true);
    }

    public SVNRevisionRange(long from, long to, boolean inheritable) {
        this.from = SVNRevision.fromNumber(from);
        this.to = SVNRevision.fromNumber(to);
        this.inheritable = inheritable;
    }

    public SVNRevisionRange(SVNRevision from, SVNRevision to) {
        this(from, to, true);
    }

    public SVNRevisionRange(SVNRevision from, SVNRevision to, boolean inheritable) {
        if (from == null) {
            throw new NullPointerException("The \"from\" field cannot be initialized with null");
        }
        if (to == null) {
            throw new NullPointerException("The \"to\" field cannot be initialized with null");
        }
        this.from = from;
        this.to = to;
        this.inheritable = inheritable;
    }

    public SVNRevisionRange(String revisionElement) {
        int hyphen;
        boolean bl = this.inheritable = !revisionElement.endsWith("*");
        if (!this.inheritable) {
            revisionElement = revisionElement.substring(0, revisionElement.length() - 1);
        }
        if ((hyphen = revisionElement.indexOf(45)) > 0) {
            this.from = SVNRevision.fromNumber(Long.parseLong(revisionElement.substring(0, hyphen)));
            this.to = SVNRevision.fromNumber(Long.parseLong(revisionElement.substring(hyphen + 1)));
        } else {
            long rev = Long.parseLong(revisionElement.trim());
            this.to = SVNRevision.fromNumber(rev);
            this.from = SVNRevision.fromNumber(rev - 1L);
        }
    }

    public String toString() {
        if (this.from.equals(this.to) || this.from.getKind() == SVNRevision.Kind.NUMBER && this.from.getKind() == this.to.getKind() && ((SVNRevision.Number)this.from).getNumber() == ((SVNRevision.Number)this.to).getNumber() - 1L) {
            return this.from.toString() + (this.inheritable ? "" : "*");
        }
        return this.from.toString() + "-" + this.to.toString() + (this.inheritable ? "" : "*");
    }

    public int hashCode() {
        int result = this.inheritable ? 1 : 2;
        result = 31 * result + this.from.hashCode();
        result = 31 * result + this.to.hashCode();
        return result;
    }

    public boolean equals(Object range) {
        if (this == range) {
            return true;
        }
        if (!(range instanceof SVNRevisionRange)) {
            return false;
        }
        SVNRevisionRange other = (SVNRevisionRange)range;
        return this.from.equals(other.from) && this.to.equals(other.to) && this.inheritable == other.inheritable;
    }
}

