/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.operation;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class FileToClipboardOperation
extends AbstractActionOperation {
    protected String fileName;
    protected boolean deleteFile;
    protected String charset;

    public FileToClipboardOperation(String fileName) {
        this(fileName, "UTF-8");
    }

    public FileToClipboardOperation(String fileName, String charset) {
        this(fileName, charset, true);
    }

    public FileToClipboardOperation(String fileName, String charset, boolean deleteFile) {
        super("Operation_FileToClipboard", SVNUIMessages.class);
        this.fileName = fileName;
        this.deleteFile = deleteFile;
        this.charset = charset;
    }

    public int getOperationWeight() {
        return 0;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        File tempFile = new File(this.fileName);
        FileInputStream stream = new FileInputStream(tempFile);
        try {
            byte[] buf = new byte[2048];
            int len = 0;
            while ((len = stream.read(buf)) > 0) {
                data.write(buf, 0, len);
            }
        }
        catch (Throwable throwable) {
            try {
                stream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (Exception exception) {}
        if (this.deleteFile) {
            tempFile.delete();
        }
        String text = data.toString(this.charset);
        if (data.size() > 0) {
            Display display = UIMonitorUtility.getDisplay();
            display.syncExec(() -> {
                TextTransfer plainTextTransfer = TextTransfer.getInstance();
                Clipboard clipboard = new Clipboard(display);
                clipboard.setContents((Object[])new String[]{text}, new Transfer[]{plainTextTransfer});
                clipboard.dispose();
            });
        }
    }
}

