/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.history.model;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.history.data.HistoryCategory;
import org.eclipse.team.svn.ui.history.data.RootHistoryCategory;
import org.eclipse.team.svn.ui.history.data.SVNLocalFileRevision;
import org.eclipse.team.svn.ui.history.model.AbstractLogNode;
import org.eclipse.team.svn.ui.history.model.ILogNode;
import org.eclipse.team.svn.ui.history.model.LocalLogNode;
import org.eclipse.team.svn.ui.history.model.PlainTextLogNode;
import org.eclipse.team.svn.ui.history.model.SVNLogNode;

public class CategoryLogNode
extends AbstractLogNode {
    protected HistoryCategory category;

    public CategoryLogNode(RootHistoryCategory category) {
        this(category, null);
    }

    public CategoryLogNode(HistoryCategory category, ILogNode parent) {
        super(parent);
        this.category = category;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(HistoryCategory.class)) {
            return this.category;
        }
        return null;
    }

    @Override
    public ILogNode[] getChildren() {
        Object[] entries = this.category.getEntries();
        ILogNode[] children = new ILogNode[entries.length];
        int i = 0;
        while (i < entries.length) {
            if (entries[i] instanceof SVNLogEntry) {
                children[i] = new SVNLogNode((SVNLogEntry)entries[i], this);
            } else if (entries[i] instanceof SVNLocalFileRevision) {
                children[i] = new LocalLogNode((SVNLocalFileRevision)((Object)entries[i]), this);
            } else if (entries[i] instanceof HistoryCategory) {
                children[i] = new CategoryLogNode((HistoryCategory)entries[i], this);
            } else if (entries[i] instanceof String) {
                children[i] = new PlainTextLogNode((String)entries[i], this);
            }
            ++i;
        }
        return children;
    }

    @Override
    public Object getEntity() {
        return this.category;
    }

    @Override
    public boolean requiresBoldFont(long currentRevision) {
        return true;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/group_by_date.gif");
    }

    @Override
    public String getLabel(int columnIndex, int labelType, long currentRevision) {
        if (columnIndex == 0) {
            return this.category.getName();
        }
        return "";
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public String getAuthor() {
        return "";
    }

    @Override
    public int getChangesCount() {
        return 0;
    }

    @Override
    public String getComment() {
        return "";
    }

    @Override
    public long getRevision() {
        return -1L;
    }

    @Override
    public long getTimeStamp() {
        return 0L;
    }

    public int hashCode() {
        return this.category.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CategoryLogNode) {
            return this.category.equals(((CategoryLogNode)obj).category);
        }
        return false;
    }
}

