/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import java.io.FileOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.operation.AbstractGetFileContentOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class GetFileContentOperation
extends AbstractGetFileContentOperation {
    protected IRepositoryResource resource;
    protected IRepositoryResourceProvider provider;

    public GetFileContentOperation(IRepositoryResource resource) {
        super("Revision");
        this.resource = resource;
    }

    public GetFileContentOperation(IRepositoryResourceProvider provider) {
        super("Revision");
        this.provider = provider;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        if (this.provider != null) {
            this.resource = this.provider.getRepositoryResources()[0];
        }
        String url = this.resource.getUrl();
        IRepositoryLocation location = this.resource.getRepositoryLocation();
        ISVNConnector proxy = location.acquireSVNProxy();
        FileOutputStream stream = null;
        try {
            url = SVNUtility.encodeURL(url);
            this.tmpFile = this.createTempFile();
            stream = new FileOutputStream(this.tmpFile);
            proxy.streamFileContent(SVNUtility.getEntryRevisionReference(this.resource), 2048L, stream, new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            location.releaseSVNProxy(proxy);
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected String getExtension() {
        String name = this.resource.getName();
        int idx = name.lastIndexOf(46);
        return idx == -1 ? "" : name.substring(idx + 1);
    }

    protected String getShortErrorMessage(Throwable t) {
        return BaseMessages.format(super.getShortErrorMessage(t), new Object[]{this.resource.getUrl()});
    }
}

