/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local.refactor;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.SVNResourceRuleFactory;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteResourceOperation
extends AbstractActionOperation {
    protected IResource[] resources;
    protected long options;
    protected static final IStateFilter SF_OBSTRUCTED_OR_NEW = new IStateFilter.AbstractStateFilter(){

        public boolean acceptImpl(ILocalResource local, IResource resource, String state, int mask) {
            return IStateFilter.SF_OBSTRUCTED.accept(resource, state, mask) || IStateFilter.SF_NEW.accept(resource, state, mask);
        }

        public boolean allowsRecursionImpl(ILocalResource local, IResource resource, String state, int mask) {
            return IStateFilter.SF_OBSTRUCTED.allowsRecursion(resource, state, mask) || IStateFilter.SF_NEW.allowsRecursion(resource, state, mask);
        }
    };

    public DeleteResourceOperation(IResource resource) {
        this(new IResource[]{resource}, false);
    }

    public DeleteResourceOperation(IResource resource, boolean keepLocal) {
        this(new IResource[]{resource}, keepLocal);
    }

    public DeleteResourceOperation(IResource[] resources) {
        this(resources, false);
    }

    public DeleteResourceOperation(IResource[] resources, boolean keepLocal) {
        this(resources, 4L | (keepLocal ? 65536L : 0L));
    }

    public DeleteResourceOperation(IResource[] resources, long options) {
        super("Operation_DeleteLocal", SVNMessages.class);
        this.resources = resources;
        this.options = options;
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        ISchedulingRule[] rules = new ISchedulingRule[this.resources.length];
        int i = 0;
        while (i < this.resources.length) {
            rules[i] = SVNResourceRuleFactory.INSTANCE.deleteRule(this.resources[i]);
            ++i;
        }
        return new MultiRule(rules);
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        ArrayList<IResource> resourcesList = new ArrayList<IResource>(Arrays.asList(this.resources));
        this.cleanupResourcesList(resourcesList, SF_OBSTRUCTED_OR_NEW);
        if (resourcesList.size() == 0) {
            return;
        }
        IResource[] allResources = resourcesList.toArray(new IResource[resourcesList.size()]);
        Map<IProject, List<IResource>> project2Resources = SVNUtility.splitWorkingCopies(allResources);
        for (Map.Entry<IProject, List<IResource>> entry : project2Resources.entrySet()) {
            IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation((IResource)entry.getKey());
            IResource[] resources = entry.getValue().toArray(new IResource[entry.getValue().size()]);
            String[] wcPaths = new String[resources.length];
            String printedPath = "";
            int i = 0;
            while (i < resources.length) {
                wcPaths[i] = FileUtility.getWorkingCopyPath(resources[i]);
                printedPath = String.valueOf(printedPath) + " \"" + wcPaths[i] + "\"";
                ++i;
            }
            ISVNConnector proxy = location.acquireSVNProxy();
            try {
                this.writeToConsole(0, "svn delete " + printedPath + ISVNConnector.Options.asCommandLine(this.options) + "\n");
                proxy.removeLocal(wcPaths, this.options, new SVNProgressMonitor(this, monitor, null));
            }
            finally {
                location.releaseSVNProxy(proxy);
            }
        }
    }

    protected void cleanupResourcesList(List<IResource> resources, IStateFilter filter) {
        Iterator<IResource> it = resources.iterator();
        while (it.hasNext()) {
            IResource resource = it.next();
            String wcPath = FileUtility.getWorkingCopyPath(resource);
            if (!filter.accept(SVNRemoteStorage.instance().asLocalResourceAccessible(resource))) continue;
            it.remove();
            FileUtility.deleteRecursive(new File(wcPath));
        }
    }

    @Override
    protected String getShortErrorMessage(Throwable t) {
        Object[] wcPaths = new String[this.resources.length];
        int i = 0;
        while (i < this.resources.length) {
            wcPaths[i] = FileUtility.getWorkingCopyPath(this.resources[i]);
            ++i;
        }
        return BaseMessages.format(super.getShortErrorMessage(t), wcPaths);
    }
}

