/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.verifier;

import org.eclipse.swt.widgets.Control;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.verifier.AbstractFormattedVerifier;

public class IntegerFieldVerifier
extends AbstractFormattedVerifier {
    protected static String ERROR_NAN;
    protected static String ERROR_NEGATIVE;
    protected boolean positive;

    public IntegerFieldVerifier(String fieldName, boolean positive) {
        super(fieldName);
        this.positive = positive;
        ERROR_NAN = SVNUIMessages.format((String)SVNUIMessages.Verifier_IntegerField_NaN, (Object[])new String[]{"$FIELD_NAME$"});
        ERROR_NEGATIVE = SVNUIMessages.format((String)SVNUIMessages.Verifier_IntegerField_Negative, (Object[])new String[]{"$FIELD_NAME$"});
    }

    protected String getErrorMessageImpl(Control input) {
        String text = this.getText(input);
        try {
            long i = Long.parseLong(text);
            if (this.positive && i < 0L) {
                return ERROR_NEGATIVE;
            }
        }
        catch (Exception ex) {
            return ERROR_NAN;
        }
        return null;
    }

    protected String getWarningMessageImpl(Control input) {
        return null;
    }
}

