/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.mapping;

import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.ui.mapping.ResourceModelSorter;
import org.eclipse.team.svn.core.mapping.SVNIncomingChangeSet;
import org.eclipse.team.svn.ui.mapping.SVNChangeSetActionProvider;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class SVNChangeSetSorter
extends ResourceModelSorter
implements IPropertyChangeListener {
    public static final int DATE = 1;
    public static final int COMMENT = 2;
    public static final int USER = 3;
    private ISynchronizePageConfiguration configuration;
    private int reorderingCriteria = 1;

    public int compare(Viewer viewer, Object o1, Object o2) {
        if (o1 instanceof ChangeSet && o2 instanceof ChangeSet) {
            if (o1 instanceof ActiveChangeSet && o2 instanceof ActiveChangeSet) {
                return this.compareNames(((ActiveChangeSet)o1).getTitle(), ((ActiveChangeSet)o2).getTitle());
            }
            if (o1 instanceof SVNIncomingChangeSet && o2 instanceof SVNIncomingChangeSet) {
                SVNIncomingChangeSet r1 = (SVNIncomingChangeSet)o1;
                SVNIncomingChangeSet r2 = (SVNIncomingChangeSet)o2;
                if (this.reorderingCriteria == 2) {
                    return this.compareNames(r1.getComment(), r2.getComment());
                }
                if (this.reorderingCriteria == 3) {
                    return this.compareNames(r1.getAuthor(), r2.getAuthor());
                }
                return r1.getDate().compareTo(r2.getDate());
            }
            if (o1 instanceof ActiveChangeSet) {
                return -1;
            }
            if (o2 instanceof ActiveChangeSet) {
                return 1;
            }
            if (o1 instanceof SVNIncomingChangeSet) {
                return 1;
            }
            if (o2 instanceof SVNIncomingChangeSet) {
                return -1;
            }
        }
        return super.compare(viewer, o1, o2);
    }

    private int compareNames(String s1, String s2) {
        s1 = s1 == null ? "" : s1;
        s2 = s2 == null ? "" : s2;
        return this.collator.compare(s1, s2);
    }

    public void setConfiguration(ISynchronizePageConfiguration configuration) {
        this.configuration = configuration;
        this.configuration.addPropertyChangeListener((IPropertyChangeListener)this);
        this.reorderingCriteria = SVNChangeSetActionProvider.getSortCriteria(this.configuration);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.reorderingCriteria = SVNChangeSetActionProvider.getSortCriteria(this.configuration);
    }
}

