/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.crashrecovery;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.SVNTeamProvider;
import org.eclipse.team.svn.core.extension.crashrecovery.ErrorDescription;
import org.eclipse.team.svn.core.extension.crashrecovery.IResolutionHelper;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.management.FindRelatedProjectsOperation;
import org.eclipse.team.svn.core.operation.local.management.RelocateWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryRoot;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.crashrecovery.relocated.RelocationChoicesPanel;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class RelocatedProjectHelper
implements IResolutionHelper {
    public boolean acquireResolution(ErrorDescription description) {
        if (description.code == ErrorDescription.PROJECT_IS_RELOCATED_OUTSIDE_PLUGIN) {
            Object[] context = (Object[])description.context;
            final IProject project = (IProject)context[0];
            final IRepositoryLocation location = (IRepositoryLocation)context[2];
            final String relocatedTo = (String)context[1];
            IRepositoryRoot[] roots = SVNUtility.findRoots((String)relocatedTo, (boolean)true);
            if (roots.length != 0) {
                SVNTeamProvider provider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.team.svn.core.svnnature");
                try {
                    provider.switchResource((IRepositoryResource)roots[0].asRepositoryContainer(relocatedTo, false));
                    return true;
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            final RelocationChoicesPanel panel = new RelocationChoicesPanel(project);
            UIMonitorUtility.parallelSyncExec(new Runnable(){

                public void run() {
                    DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getShell(), panel);
                    dialog.open();
                }
            });
            if (panel.getRecoveryAction() == -1) {
                return false;
            }
            if (panel.getRecoveryAction() == 0) {
                RelocateWorkingCopyOperation mainOp = new RelocateWorkingCopyOperation(new IResource[]{project}, location);
                ProgressMonitorUtility.doTaskExternal((IActionOperation)mainOp, (IProgressMonitor)new NullProgressMonitor());
                ProgressMonitorUtility.doTaskScheduled((IActionOperation)new RefreshResourcesOperation((IResourceProvider)mainOp));
                return mainOp.getExecutionState() == 0;
            }
            if (panel.getRecoveryAction() == 1) {
                final IRepositoryLocation backup = SVNRemoteStorage.instance().newRepositoryLocation();
                SVNRemoteStorage.instance().copyRepositoryLocation(backup, location);
                FindRelatedProjectsOperation scannerOp = new FindRelatedProjectsOperation(location, new IProject[]{project});
                final RelocateWorkingCopyOperation mainOp = new RelocateWorkingCopyOperation((IResourceProvider)scannerOp, location);
                CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
                op.add((IActionOperation)scannerOp);
                op.add((IActionOperation)new AbstractWorkingCopyOperation("Operation_ChangeRepositoryLocation", SVNUIMessages.class, new IResource[]{project}){

                    protected void runImpl(IProgressMonitor monitor) throws Exception {
                        location.setUrl(relocatedTo);
                        location.setUrl(location.getRepositoryRootUrl());
                        SVNTeamProvider provider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.team.svn.core.svnnature");
                        provider.relocateResource();
                    }
                });
                op.add((IActionOperation)mainOp);
                op.add((IActionOperation)new AbstractWorkingCopyOperation("Operation_CheckRelocationState", SVNUIMessages.class, new IResource[]{project}){

                    protected void runImpl(IProgressMonitor monitor) throws Exception {
                        if (mainOp.getExecutionState() != 0) {
                            SVNRemoteStorage.instance().copyRepositoryLocation(location, backup);
                            SVNTeamProvider provider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.team.svn.core.svnnature");
                            provider.relocateResource();
                        }
                    }
                });
                ProgressMonitorUtility.doTaskExternal((IActionOperation)op, (IProgressMonitor)new NullProgressMonitor());
                ProgressMonitorUtility.doTaskScheduled((IActionOperation)new RefreshResourcesOperation((IResourceProvider)mainOp));
                return true;
            }
            if (panel.getRecoveryAction() == 2) {
                try {
                    SVNTeamProvider provider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.team.svn.core.svnnature");
                    IRepositoryLocation newLocation = SVNRemoteStorage.instance().newRepositoryLocation();
                    SVNRemoteStorage.instance().copyRepositoryLocation(newLocation, location);
                    newLocation.setUrl(relocatedTo);
                    newLocation.setUrl(newLocation.getRepositoryRootUrl());
                    SVNRemoteStorage.instance().addRepositoryLocation(newLocation);
                    SVNTeamPlugin.instance().setLocationsDirty(true);
                    provider.switchResource((IRepositoryResource)newLocation.asRepositoryContainer(relocatedTo, false));
                }
                catch (CoreException ex) {
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

