/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui;

import org.eclipse.core.resources.team.FileModificationValidator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.team.svn.core.connector.ISVNCredentialsPrompt;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.extension.options.AbstractOptionProvider;
import org.eclipse.team.svn.core.extension.options.IOptionProvider;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.utility.ILoggedOperationFactory;
import org.eclipse.team.svn.core.utility.PatternProvider;
import org.eclipse.team.svn.core.utility.StringMatcher;
import org.eclipse.team.svn.ui.SVNTeamModificationValidator;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.operation.RefreshRepositoryLocationsOperation;
import org.eclipse.team.svn.ui.panel.callback.PromptCredentialsPanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.preferences.SVNTeamPropsPreferencePage;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class UIOptionProvider
extends AbstractOptionProvider {
    private SVNTeamModificationValidator modificationValidator = new SVNTeamModificationValidator();
    public static final String ID = "org.eclipse.team.svn.ui.optionprovider";

    public String getId() {
        return ID;
    }

    public String[] getCoveredProviders() {
        return new String[]{IOptionProvider.DEFAULT.getId()};
    }

    public ISVNCredentialsPrompt getCredentialsPrompt() {
        return PromptCredentialsPanel.DEFAULT_PROMPT;
    }

    public ILoggedOperationFactory getLoggedOperationFactory() {
        return UIMonitorUtility.DEFAULT_FACTORY;
    }

    public void addProjectSetCapabilityProcessing(CompositeOperation op) {
        op.add((IActionOperation)new RefreshRepositoryLocationsOperation(false));
    }

    public FileModificationValidator getFileModificationValidator() {
        return this.modificationValidator;
    }

    public SVNProperty[] getAutomaticProperties(String template) {
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        Object[] autoProperties = SVNTeamPropsPreferencePage.loadAutoProperties(SVNTeamPreferences.getAutoPropertiesList(store, "autoproperties"));
        int i = 0;
        while (i < autoProperties.length) {
            StringMatcher matcher;
            SVNTeamPropsPreferencePage.AutoProperty autoProperty = (SVNTeamPropsPreferencePage.AutoProperty)autoProperties[i];
            if (autoProperty.enabled && (matcher = new StringMatcher(autoProperty.fileName)).match(template)) {
                if (autoProperty.properties.length() == 0) {
                    return new SVNProperty[0];
                }
                String[] props = autoProperty.properties.split(System.getProperty("line.separator"));
                SVNProperty[] propertyData = new SVNProperty[props.length];
                int j = 0;
                while (j < props.length) {
                    String[] propsNameValue = props[j].split("=", 2);
                    String propVal = propsNameValue.length == 1 ? "" : propsNameValue[1];
                    propVal = PatternProvider.replaceAll((String)propVal, (String)"([^\\\\])\\\\n|^\\\\n", (String)("$1" + System.getProperty("line.separator")));
                    propVal = PatternProvider.replaceAll((String)propVal, (String)"\\\\n", (String)"n");
                    propertyData[j] = new SVNProperty(propsNameValue[0], propVal);
                    ++j;
                }
                return propertyData;
            }
            ++i;
        }
        return new SVNProperty[0];
    }

    public String getResource(String key) {
        return SVNUIMessages.getErrorString(key);
    }

    protected String getSVNConnectorId() {
        return SVNTeamPreferences.getCoreString(SVNTeamUIPlugin.instance().getPreferenceStore(), "svnconnector");
    }

    protected String getDefaultTrunkName() {
        String retVal = SVNTeamPreferences.getRepositoryString(SVNTeamUIPlugin.instance().getPreferenceStore(), "head");
        if (retVal == null || retVal.length() == 0) {
            retVal = "trunk";
        }
        return retVal;
    }

    protected String getDefaultBranchesName() {
        String retVal = SVNTeamPreferences.getRepositoryString(SVNTeamUIPlugin.instance().getPreferenceStore(), "branches");
        if (retVal == null || retVal.length() == 0) {
            retVal = "branches";
        }
        return retVal;
    }

    protected String getDefaultTagsName() {
        String retVal = SVNTeamPreferences.getRepositoryString(SVNTeamUIPlugin.instance().getPreferenceStore(), "tags");
        if (retVal == null || retVal.length() == 0) {
            retVal = "tags";
        }
        return retVal;
    }

    protected boolean isAutomaticProjectShareEnabled() {
        return SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "share.enableAuto");
    }

    protected boolean isSVNCacheEnabled() {
        return SVNTeamPreferences.getDecorationBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "enable.cache");
    }

    protected boolean isTextMIMETypeRequired() {
        return SVNTeamPreferences.getPropertiesBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "forceTextMime");
    }

    protected boolean isPersistentSSHEnabled() {
        return SVNTeamPreferences.getDecorationBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "enable.persistent.ssh");
    }

    protected boolean isCommitDerivedEnabled() {
        return SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "resourceSelection.selectDerived");
    }
}

