/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.mylyn;

import java.util.Collection;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.action.IResourceSelector;
import org.eclipse.team.svn.ui.action.local.CommitAction;
import org.eclipse.team.svn.ui.extension.ExtensionsManager;
import org.eclipse.team.svn.ui.extension.factory.ICommentDialogPanel;
import org.eclipse.team.svn.ui.extension.factory.ICommitDialog;
import org.eclipse.team.svn.ui.mapping.ModelHelper;
import org.eclipse.team.svn.ui.mapping.SVNModelParticipantChangeSetCapability;
import org.eclipse.team.svn.ui.panel.local.CommitPanel;
import org.eclipse.team.svn.ui.synchronize.SVNChangeSetCapability;
import org.eclipse.team.svn.ui.utility.CommitActionUtility;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class SVNCommitWorkflowProvider {
    public boolean hasOutgoingChanges(IResource[] resources) {
        return FileUtility.checkForResourcesPresence((IResource[])resources, (IStateFilter)CommitAction.SF_ANY_CHANGE, (int)0);
    }

    public void commit(final IResource[] resources) {
        CommitActionUtility commitUtility = new CommitActionUtility(new IResourceSelector(){

            public IResource[] getSelectedResources() {
                return resources;
            }

            public IResource[] getSelectedResourcesRecursive(IStateFilter filter) {
                return this.getSelectedResources(filter);
            }

            public IResource[] getSelectedResourcesRecursive(IStateFilter filter, int depth) {
                return this.getSelectedResources(filter);
            }

            public IResource[] getSelectedResources(IStateFilter filter) {
                return FileUtility.getResourcesRecursive((IResource[])this.getSelectedResources(), (IStateFilter)filter, (int)0);
            }
        });
        String proposedComment = ModelHelper.isShowModelSync() ? SVNModelParticipantChangeSetCapability.getProposedComment((IResource[])commitUtility.getAllResources()) : SVNChangeSetCapability.getProposedComment((IResource[])commitUtility.getAllResources());
        CommitPanel commitPanel = new CommitPanel(commitUtility.getAllResources(), 0, proposedComment);
        Shell shell = UIMonitorUtility.getShell();
        ICommitDialog commitDialog = ExtensionsManager.getInstance().getCurrentCommitFactory().getCommitDialog(shell, (Collection)commitUtility.getAllResourcesSet(), (ICommentDialogPanel)commitPanel);
        if (commitDialog.open() == 0) {
            IResource[] selectedResources = commitPanel.getSelectedResources();
            IWorkbenchWindow window = SVNTeamUIPlugin.instance().getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPart part = window == null ? null : window.getPartService().getActivePart();
            CompositeOperation op = commitUtility.getCompositeCommitOperation(selectedResources, commitPanel.getTreatAsEdits(), commitDialog.getMessage(), commitPanel.getKeepLocks(), shell, part);
            UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
        }
    }
}

