/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.resource.events;

import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.svn.core.resource.events.ResourceStatesChangedEvent;

public class ProjectStatesChangedEvent
extends ResourceStatesChangedEvent {
    public static final int ST_POST_SHARED = 0;
    public static final int ST_POST_DISCONNECTED = 1;
    public static final int ST_PRE_SHARED = 2;
    public static final int ST_PRE_DISCONNECTED = 3;
    public static final int ST_PRE_CLOSED = 4;
    public static final int ST_PRE_DELETED = 5;
    public final int newState;

    public ProjectStatesChangedEvent(IProject[] projects, int newState) {
        super((IResource[])projects, 0, 0);
        this.newState = newState;
    }

    public boolean canMerge(ResourceStatesChangedEvent e) {
        if (e instanceof ProjectStatesChangedEvent) {
            return super.canMerge(e) && this.newState == ((ProjectStatesChangedEvent)e).newState;
        }
        return false;
    }

    public ProjectStatesChangedEvent merge(ResourceStatesChangedEvent event) {
        IProject[] arr = new IProject[this.resources.length + event.resources.length];
        System.arraycopy(this.resources, 0, arr, 0, this.resources.length);
        System.arraycopy(event.resources, 0, arr, this.resources.length, event.resources.length);
        return new ProjectStatesChangedEvent(arr, this.newState);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.newState;
        result = 31 * result + Arrays.hashCode(this.resources);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProjectStatesChangedEvent)) {
            return false;
        }
        ProjectStatesChangedEvent other = (ProjectStatesChangedEvent)obj;
        if (this.newState != other.newState) {
            return false;
        }
        return Arrays.equals(this.resources, other.resources);
    }
}

