/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.eclipse.team.svn.core.utility.FileUtility;

public class RestoreProjectMetaOperation
extends AbstractActionOperation {
    protected SaveProjectMetaOperation saveOp;
    protected boolean force;

    public RestoreProjectMetaOperation(SaveProjectMetaOperation saveOp) {
        this(saveOp, false);
    }

    public RestoreProjectMetaOperation(SaveProjectMetaOperation saveOp, boolean force) {
        super("Operation_RestoreMeta", SVNMessages.class);
        this.saveOp = saveOp;
        this.force = force;
    }

    public ISchedulingRule getSchedulingRule() {
        return this.saveOp.getSchedulingRule();
    }

    public int getOperationWeight() {
        return 0;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        Map<String, File> container = this.saveOp.getSavedMetas();
        Iterator<Map.Entry<String, File>> it = container.entrySet().iterator();
        while (it.hasNext() && !monitor.isCanceled()) {
            Map.Entry<String, File> entry = it.next();
            final File targetFile = new File(entry.getKey());
            final File savedCopy = entry.getValue();
            if (targetFile.getParentFile().exists()) {
                if (savedCopy.isDirectory()) {
                    this.protectStep(new IUnprotectedOperation(){

                        public void run(IProgressMonitor monitor) throws Exception {
                            try {
                                if (RestoreProjectMetaOperation.this.force) {
                                    FileUtility.copyAll(targetFile.getParentFile(), savedCopy.listFiles()[0], 3, null, monitor);
                                } else {
                                    FileUtility.copyAll(targetFile.getParentFile(), savedCopy.listFiles()[0], 1, null, monitor);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }, monitor, container.size());
                } else if (!targetFile.exists() || this.force) {
                    this.protectStep(new IUnprotectedOperation(){

                        public void run(IProgressMonitor monitor) throws Exception {
                            try {
                                FileUtility.copyFile(targetFile, savedCopy, monitor);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }, monitor, container.size());
                }
            }
            FileUtility.deleteRecursive(savedCopy);
        }
    }
}

