/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.composite;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.ui.utility.ArrayStructuredContentProvider;
import org.eclipse.ui.dialogs.ListDialog;

public class SSLClientCertificatesMSCapi
extends ListDialog {
    protected String alias;

    public SSLClientCertificatesMSCapi(Shell parent, String realm) {
        super(parent);
        ArrayList<String[]> list = new ArrayList<String[]>();
        Provider pmscapi = Security.getProvider("SunMSCAPI");
        Provider pjacapi = Security.getProvider("CAPI");
        try {
            KeyStore keyStore = null;
            if (pmscapi != null) {
                keyStore = KeyStore.getInstance("Windows-MY", pmscapi);
                pmscapi.setProperty("Signature.SHA1withRSA", "sun.security.mscapi.RSASignature$SHA1");
            } else if (pjacapi != null) {
                keyStore = KeyStore.getInstance("CAPI");
            }
            if (keyStore != null) {
                keyStore.load(null, null);
                Enumeration<String> aliasEnumeration = keyStore.aliases();
                while (aliasEnumeration.hasMoreElements()) {
                    String alias = aliasEnumeration.nextElement();
                    String issuer = "";
                    Certificate cert = keyStore.getCertificate(alias);
                    if (cert instanceof X509Certificate) {
                        issuer = ((X509Certificate)cert).getIssuerDN().getName();
                    }
                    list.add(new String[]{alias, issuer});
                }
            }
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setTitle("Select Certificate Alias");
        this.setAddCancelButton(true);
        LabelProvider lp = new LabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                if (element instanceof String[] && ((String[])element).length > 1) {
                    return String.valueOf(((String[])element)[0]) + " | issued by: " + ((String[])element)[1];
                }
                return element.toString();
            }
        };
        this.setLabelProvider((ILabelProvider)lp);
        this.setMessage("select the right certificate alias");
        this.setContentProvider(new ArrayStructuredContentProvider());
        this.setInput(list.toArray());
    }

    public String getAlias() {
        if (this.getResult() != null && this.getResult().length > 0) {
            Object result = this.getResult()[0];
            this.alias = result instanceof String[] ? ((String[])result)[0] : (String)result;
        }
        return this.alias;
    }
}

