/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.connector;

public class SVNLogPath {
    public final String path;
    public final ChangeType action;
    public final String copiedFromPath;
    public final long copiedFromRevision;
    public final Boolean textWasModified;
    public final Boolean propertiesWereModified;

    public SVNLogPath(String path, ChangeType action, String copiedFromPath, long copiedFromRevision, Boolean textWasModified, Boolean propertiesWereModified) {
        this.path = path;
        this.copiedFromRevision = copiedFromRevision;
        this.copiedFromPath = copiedFromPath;
        this.action = action;
        this.textWasModified = textWasModified;
        this.propertiesWereModified = propertiesWereModified;
    }

    public String toString() {
        return String.valueOf(String.valueOf((Object)this.action)) + ":" + this.path;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChangeType {
        ADDED('A'),
        DELETED('D'),
        REPLACED('R'),
        MODIFIED('M');

        public final char id;

        public static ChangeType fromId(char id) {
            ChangeType[] changeTypeArray = ChangeType.values();
            int n = changeTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ChangeType kind = changeTypeArray[n2];
                if (kind.id == id) {
                    return kind;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Invalid change kind: " + id);
        }

        private ChangeType(char id) {
            this.id = id;
        }
    }
}

