/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.reports;

import java.util.List;
import java.util.Objects;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.core.Response;
import org.eclipse.osee.define.operations.api.DefineOperations;
import org.eclipse.osee.define.operations.publisher.publishing.PublishingPermissions;
import org.eclipse.osee.define.operations.publisher.publishing.UserNotAuthorizedForPublishingException;
import org.eclipse.osee.define.operations.reports.FeatureImpactStreamingOutput;
import org.eclipse.osee.define.rest.api.reports.ReportsEndpoint;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.BranchQuery;

public class ReportsEndpointImpl
implements ReportsEndpoint {
    private final DefineOperations defineOperations;
    private final OrcsApi orcsApi;

    public ReportsEndpointImpl(DefineOperations defineOperations, OrcsApi orcsApi) {
        this.defineOperations = Objects.requireNonNull(defineOperations);
        this.orcsApi = Objects.requireNonNull(orcsApi);
    }

    public Response applicabilityImpact(BranchId branch, String publish, List<ArtifactTypeToken> artTypes, List<AttributeTypeToken> attrTypes) {
        boolean publishUpdates = publish.equals("true");
        try {
            PublishingPermissions.verifyNonGroup();
            Branch branchArt = (Branch)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(branch)).getResults().getAtMostOneOrDefault((Object)Branch.SENTINEL);
            FeatureImpactStreamingOutput streamingOutput = new FeatureImpactStreamingOutput(branchArt, this.orcsApi, this.defineOperations, publishUpdates, artTypes, attrTypes);
            Response.ResponseBuilder builder = Response.ok((Object)streamingOutput);
            builder.header("Content-Disposition", (Object)("attachment; filename=" + branchArt.getName().replaceAll("[^a-zA-Z0-9-]", "_") + ".zip"));
            return builder.build();
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }
}

