/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal.importing;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;

public final class NormalizeHtml {
    private static final TreeMap<Integer, String> FONT_MAP = NormalizeHtml.initializeFontMap();
    private static final String[] FONT_VALUES = FONT_MAP.values().toArray(new String[0]);
    private static final String MEDIUM_FONT = "medium;";
    private static final String CHARSET = "UTF-8";
    private static final int INDENT_AMOUNT = 4;
    private static final String ldquo = String.valueOf('\u201c');
    private static final String rdquo = String.valueOf('\u201d');
    private static final String lsquo = String.valueOf('\u2018');
    private static final String rsquo = String.valueOf('\u2019');
    private static final String figureDash = String.valueOf('\u2012');
    private static final String enDash = String.valueOf('\u2013');
    private static final String emDash = String.valueOf('\u2014');
    private static final String NON_BREAK_SPACE = String.valueOf('\u00a0');
    private static final String NON_BREAK_FIGURE_SPACE = String.valueOf('\u2007');
    private static final String NON_BREAK_NARROW_SPACE = String.valueOf('\u202f');
    private static final String NON_BREAK_WORD_JOINER = String.valueOf('\u2060');
    private static final String NON_BREAK_ZERO_WIDTH = String.valueOf('\ufeff');
    private static ArrayList<String> allowedAttributes = null;
    private static final String HTMLHEAD = "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\"><html><body>";
    private static final String HTMLTAIL = "</body></html>";

    static {
        allowedAttributes = new ArrayList();
        allowedAttributes.add("border");
        allowedAttributes.add("frame");
        allowedAttributes.add("rules");
        allowedAttributes.add("valign");
        allowedAttributes.add("src");
    }

    private NormalizeHtml() {
    }

    private static TreeMap<Integer, String> initializeFontMap() {
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        map.put(8, "xx-small;");
        map.put(11, "small;");
        map.put(13, MEDIUM_FONT);
        map.put(16, "large;");
        map.put(20, "x-large;");
        map.put(28, "xx-large;");
        map.put(Integer.MAX_VALUE, "300%;");
        return map;
    }

    public static String wrapAndNormalizeHTML(String htmlBody, boolean removeInitialStyle, boolean removeEmptyTags, boolean removeHeaderFooter) {
        htmlBody = HTMLHEAD + htmlBody + HTMLTAIL;
        return NormalizeHtml.convertToNormalizedHTML(htmlBody, removeInitialStyle, removeEmptyTags, removeHeaderFooter);
    }

    public static String convertToNormalizedHTML(String inputHTML) {
        return NormalizeHtml.convertToNormalizedHTML(inputHTML, false, false, false);
    }

    public static String convertToNormalizedHTML(String inputHTML, boolean removeInitialStyle, boolean removeEmptyTags, boolean removeHeaderFooter) {
        Document doc = Jsoup.parse((String)inputHTML);
        doc.quirksMode(Document.QuirksMode.noQuirks);
        Document.OutputSettings outputSettings = doc.outputSettings();
        outputSettings.charset(CHARSET);
        outputSettings.escapeMode(Entities.EscapeMode.xhtml);
        outputSettings.prettyPrint(true);
        outputSettings.outline(true);
        outputSettings.indentAmount(4);
        doc.outputSettings(outputSettings);
        Elements bold = doc.select("b");
        for (Element e : bold) {
            e.tagName("strong");
        }
        Elements italic = doc.select("i");
        for (Element e : italic) {
            e.tagName("em");
        }
        Elements underline = doc.select("u");
        for (Element e : underline) {
            e.tagName("span");
            e.attr("style", "text-decoration: underline;");
        }
        Elements strike = doc.select("strike");
        for (Element e : strike) {
            e.tagName("span");
            e.attr("style", "text-decoration: line-through;");
        }
        NormalizeHtml.removeDepreactedTags(doc);
        NormalizeHtml.processTagsWithAttributes(doc);
        NormalizeHtml.processHeaderFooter(doc, removeHeaderFooter);
        NormalizeHtml.processFontTags(doc);
        NormalizeHtml.processInitialStyleTags(doc, removeInitialStyle);
        NormalizeHtml.processEmptyTags(doc, removeEmptyTags);
        NormalizeHtml.processSelfFormattingTags(doc);
        return NormalizeHtml.processText(doc);
    }

    static void processSelfFormattingTags(Document doc) {
        String[] tagsToCheck;
        String[] stringArray = tagsToCheck = new String[]{"li", "tr", "td", "table"};
        int n = tagsToCheck.length;
        int n2 = 0;
        while (n2 < n) {
            String select = stringArray[n2];
            Elements theNode = doc.select(select);
            ArrayList<Object> remove = new ArrayList<Object>();
            for (Element element : theNode) {
                List kids = element.childNodes();
                for (Node n3 : kids) {
                    if (n3 instanceof TextNode) {
                        TextNode t = (TextNode)n3;
                        String theText = t.text();
                        theText = theText.replaceAll(NON_BREAK_SPACE, " ");
                        theText = theText.replaceAll(NON_BREAK_FIGURE_SPACE, " ");
                        theText = theText.replaceAll(NON_BREAK_NARROW_SPACE, " ");
                        theText = theText.replaceAll(NON_BREAK_WORD_JOINER, " ");
                        theText = theText.replaceAll(NON_BREAK_ZERO_WIDTH, " ");
                        if ((theText = theText.trim().replaceAll("\\s+", "")).isEmpty()) {
                            remove.add(t);
                            continue;
                        }
                        theText = t.text().trim();
                        String nbsp = "&nbsp;";
                        theText = theText.replaceAll(NON_BREAK_SPACE, nbsp);
                        theText = theText.replaceAll(NON_BREAK_FIGURE_SPACE, nbsp);
                        theText = theText.replaceAll(NON_BREAK_NARROW_SPACE, nbsp);
                        theText = theText.replaceAll(NON_BREAK_WORD_JOINER, nbsp);
                        theText = theText.replaceAll(NON_BREAK_ZERO_WIDTH, nbsp);
                        while (theText.indexOf(nbsp) == 0) {
                            theText = theText.substring(nbsp.length()).trim();
                        }
                        while (theText.lastIndexOf(nbsp) != -1 && theText.lastIndexOf(nbsp) == theText.length() - nbsp.length()) {
                            theText = theText.substring(0, theText.length() - nbsp.length()).trim();
                        }
                        if (theText.isEmpty()) {
                            remove.add(t);
                            continue;
                        }
                        TextNode newTextNode = TextNode.createFromEncoded((String)theText);
                        newTextNode.setBaseUri(t.baseUri());
                        t.replaceWith((Node)newTextNode);
                        continue;
                    }
                    if (!(n3 instanceof Element) || !((Element)n3).tagName().equals("br")) continue;
                    remove.add(n3);
                }
            }
            for (Node node : remove) {
                node.remove();
            }
            ++n2;
        }
    }

    static void removeDepreactedTags(Document doc) {
        Elements center = doc.select("center");
        for (Element e : center) {
            Elements children = e.children();
            for (Element c : children) {
                e.before((Node)c);
            }
            e.remove();
        }
    }

    private static synchronized void processTagsWithAttributes(Document doc) {
        Elements tables = doc.select("table");
        for (Element table : tables) {
            NormalizeHtml.removeUnsupportedAttributes(table, true);
            Elements colgroup = table.select("colgroup");
            for (Element c : colgroup) {
                c.remove();
            }
            NormalizeHtml.removeElements(table, "thead");
            NormalizeHtml.removeElements(table, "tfoot");
            NormalizeHtml.removeElements(table, "tbody");
            Elements rows = table.select("td");
            for (Element row : rows) {
                String[] attributeValues = NormalizeHtml.removeUnsupportedAttributes(row, false);
                Element tr = null;
                Element parent = row.parent();
                if (parent.tagName().equals("tr")) {
                    tr = parent;
                } else {
                    Elements siblings = row.siblingElements();
                    for (Element e : siblings) {
                        if (!e.tagName().equals("tr")) continue;
                        tr = e;
                        break;
                    }
                }
                if (tr == null) continue;
                int i = 0;
                while (i < attributeValues.length) {
                    if (attributeValues[i] != null) {
                        tr.attr(allowedAttributes.get(i), attributeValues[i].toLowerCase());
                    }
                    ++i;
                }
            }
            rows = table.select("tr");
            for (Element row : rows) {
                NormalizeHtml.removeUnsupportedAttributes(row, true);
            }
        }
        Elements images = doc.select("img");
        for (Element image : images) {
            NormalizeHtml.removeUnsupportedAttributes(image, true);
        }
    }

    static void processInitialStyleTags(Document doc, boolean removeInitialStyle) {
        if (removeInitialStyle) {
            Elements pTags = doc.select("p");
            for (Element p : pTags) {
                if (p.attr("style").equals("") || !p.hasText()) continue;
                if (!p.parent().tagName().equals("li")) {
                    Element cr = new Element(Tag.valueOf((String)"br"), p.baseUri());
                    p.after((Node)cr);
                }
                p.unwrap();
            }
            Elements span = doc.select("span");
            for (Element s : span) {
                if (s.attr("style").equals("") || s.hasText()) continue;
                s.remove();
            }
        }
    }

    private static void processEmptyTags(Document doc, boolean removeEmptyTags) {
        if (removeEmptyTags) {
            Elements pTags = doc.select("p");
            for (Element p : pTags) {
                NormalizeHtml.deleteEmptyElemens(p);
            }
            Elements span = doc.select("span");
            for (Element s : span) {
                NormalizeHtml.deleteEmptyElemens(s);
            }
            Elements div = doc.select("div");
            for (Element e : div) {
                if (!e.hasText() && !e.html().contains("<img")) {
                    e.remove();
                    continue;
                }
                e.unwrap();
            }
            Elements aTags = doc.select("a");
            for (Element a : aTags) {
                Attributes attr = a.attributes();
                if (attr.size() != 1 || attr.get("name").equals("")) continue;
                a.unwrap();
            }
        }
    }

    static void processHeaderFooter(Document doc, boolean removeHeaderFooter) {
        if (removeHeaderFooter) {
            Elements div = doc.select("div");
            for (Element d : div) {
                Elements headerFooter = d.getElementsByAttributeValueMatching("type", "HEADER*|FOOTER*");
                for (Element hf : headerFooter) {
                    hf.remove();
                }
            }
        }
    }

    private static void deleteEmptyElemens(Element elementToCheck) {
        Elements style = elementToCheck.getElementsByAttributeValueMatching("style", "font*|margin*");
        for (Element e : style) {
            if (e.hasText()) continue;
            e.unwrap();
        }
    }

    private static String processText(Document doc) {
        String theText = doc.outerHtml();
        theText = theText.replaceAll(ldquo, "\"");
        theText = theText.replaceAll(rdquo, "\"");
        theText = theText.replaceAll(lsquo, "'");
        theText = theText.replaceAll(rsquo, "'");
        theText = theText.replaceAll("&apos;", "'");
        theText = theText.replaceAll("&ndash;", "-");
        theText = theText.replaceAll(figureDash, "-");
        theText = theText.replaceAll(enDash, "-");
        theText = theText.replaceAll(emDash, "-");
        theText = theText.replaceAll(NON_BREAK_SPACE, "&nbsp;");
        theText = theText.replaceAll(NON_BREAK_FIGURE_SPACE, "&nbsp;");
        theText = theText.replaceAll(NON_BREAK_NARROW_SPACE, "&nbsp;");
        theText = theText.replaceAll(NON_BREAK_WORD_JOINER, "&nbsp;");
        theText = theText.replaceAll(NON_BREAK_ZERO_WIDTH, "&nbsp;");
        theText = theText.replaceAll("> {1,}\n", ">\n");
        return theText;
    }

    private static void processFontTags(Document doc) {
        Elements font = doc.select("font");
        for (Element e : font) {
            Attributes attrs = e.attributes().clone();
            StringBuilder styleString = new StringBuilder();
            String theSizeString = "";
            for (Attribute attribute : attrs) {
                int size;
                String attributeName = attribute.getKey();
                String attributeValue = attribute.getValue();
                if (attributeName.equalsIgnoreCase("face")) {
                    styleString.append(" font-family: ");
                    styleString.append(attributeValue);
                } else if (attributeName.equalsIgnoreCase("size")) {
                    int theSize = Integer.valueOf(attributeValue.trim());
                    if (theSize <= FONT_VALUES.length) {
                        theSizeString = FONT_VALUES[theSize - 1];
                    }
                } else if (attributeName.equalsIgnoreCase("color")) {
                    styleString.append(" color: ");
                    styleString.append(attributeValue);
                } else if (attributeName.equalsIgnoreCase("style") && (size = attributeValue.indexOf("font-size:")) != -1) {
                    theSizeString = NormalizeHtml.getFontSize(attributeValue.substring(size += "font-size:".length()));
                }
                e.removeAttr(attributeName);
            }
            if (theSizeString.length() > 0) {
                styleString.append(" font-size: ");
                styleString.append(theSizeString);
            }
            e.tagName("span");
            e.attr("style", styleString.toString());
        }
    }

    private static String getFontSize(String inputStyle) {
        String theReturn;
        int theSize = 1;
        int thePointStart = inputStyle.indexOf(32);
        int thePointEnd = inputStyle.lastIndexOf("pt");
        if (thePointStart == -1) {
            thePointStart = 0;
        }
        while (inputStyle.charAt(thePointStart) == ' ' && thePointStart < inputStyle.length()) {
            ++thePointStart;
        }
        if (thePointStart >= thePointEnd) {
            theReturn = MEDIUM_FONT;
        } else {
            theSize = Integer.valueOf(inputStyle.substring(thePointStart, thePointEnd));
            theReturn = FONT_MAP.ceilingEntry(theSize).getValue();
        }
        return theReturn;
    }

    static void removeElements(Element table, String theElementParent) {
        Elements parents = table.select(theElementParent);
        for (Element p : parents) {
            Elements children = p.children();
            for (Element c : children) {
                p.before((Node)c);
            }
            p.remove();
        }
    }

    static String[] removeUnsupportedAttributes(Element e, boolean addBack) {
        String[] attributeValues = new String[5];
        Attributes attr = e.attributes();
        for (Attribute a : attr) {
            if (!(!allowedAttributes.contains(a.getKey()) || a.getKey().equals("border") && a.getValue().equals("0"))) {
                attributeValues[NormalizeHtml.allowedAttributes.indexOf((Object)a.getKey())] = a.getValue();
            }
            e.removeAttr(a.getKey());
        }
        if (addBack) {
            int i = 0;
            while (i < attributeValues.length) {
                if (attributeValues[i] != null) {
                    e.attr(allowedAttributes.get(i), attributeValues[i]);
                }
                ++i;
            }
        }
        return attributeValues;
    }
}

